/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.temporal.DateTime;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods
extends com.jronimo.util.Methods {
    private static final Logger logger = Logger.getLogger(Methods.class);
    public static final String ENCODING_SCHEME = "UTF-8";

    protected Methods() {
    }

    public static void applyHeaders(HttpServletResponse httpServletResponse, String string, boolean bl, Map<String, String> map) {
        String string2 = null;
        string2 = DateUtils.getHttpDateString(DateTime.now(0));
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
        httpServletResponse.setHeader("Last-Modified", string2);
        if (map != null) {
            for (String string3 : map.keySet()) {
                httpServletResponse.setHeader(string3, map.get(string3));
            }
        }
        if (bl) {
            Methods.setNoCacheHeaders(httpServletResponse, string2);
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse httpServletResponse) {
        Methods.setNoCacheHeaders(httpServletResponse, null);
    }

    public static void setNoCacheHeaders(HttpServletResponse httpServletResponse, String string) {
        if (string == null) {
            string = DateUtils.getHttpDateString(DateTime.now(0));
        }
        httpServletResponse.setHeader("X-RACK-CACHE", "miss");
        httpServletResponse.setHeader("Cache-Control", "private, no-store, no-cache, must-revalidate, max-age=0, s-maxage=0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Expires", string);
    }

    public static String readInitParameterXmlSnippet(ServletConfig servletConfig, String string) {
        return servletConfig.getInitParameter(string).replaceAll("CDATASTART", "<![CDATA[").replaceAll("CDATAEND", "]]>");
    }

    public static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            if (string != null) {
                byArray = string.getBytes(ENCODING_SCHEME);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return byArray;
    }

    public static String getCookieValue(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        Cookie cookie = null;
        try {
            for (Cookie cookie2 : httpServletRequest.getCookies()) {
                if (!cookie2.getName().equals(string)) continue;
                cookie = cookie2;
                break;
            }
            if (cookie != null) {
                string2 = cookie.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static Cookie createCookie(String string, String string2) {
        Cookie cookie = null;
        cookie = new Cookie(string, string2);
        cookie.setMaxAge(31536000);
        return cookie;
    }

    public static void displayRequestPathInformation(HttpServletRequest httpServletRequest) {
        System.out.println("request.getContextPath(): " + httpServletRequest.getContextPath());
        System.out.println("request.getPathInfo(): " + httpServletRequest.getPathInfo());
        System.out.println("request.getPathTranslated(): " + httpServletRequest.getPathTranslated());
        System.out.println("request.getQueryString(): " + httpServletRequest.getQueryString());
        System.out.println("request.getRequestURI(): " + httpServletRequest.getRequestURI());
        System.out.println("request.getRequestURL(): " + httpServletRequest.getRequestURL());
        System.out.println("request.getServletPath(): " + httpServletRequest.getServletPath());
    }

    public static boolean hasQueryString(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        String string = null;
        string = httpServletRequest.getQueryString();
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isImageFile(String string) {
        boolean bl = false;
        for (String string2 : new String[]{".png", ".gif", ".jpg", ".jpeg", ".jpe", ".ico"}) {
            if (!string.endsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getStringAttribute(HttpSession httpSession, String string) {
        return Methods.getStringAttribute(httpSession, string, null);
    }

    public static String getStringAttribute(HttpSession httpSession, String string, String string2) {
        String string3 = string2;
        Object object = null;
        object = httpSession.getAttribute(string);
        if (object != null) {
            string3 = object.toString();
        }
        return string3;
    }

    public static String addQueryStringElement(String string, String string2, String string3) {
        StringBuffer stringBuffer = null;
        int n = 0;
        String string4 = null;
        if (string == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name must not be null.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("name must not be zero length.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("value must not be null.");
        }
        stringBuffer = new StringBuffer(string);
        n = string.length();
        if (n == 0) {
            stringBuffer.append("?");
        } else if (string.indexOf("?") < 0) {
            stringBuffer.append("?");
        } else {
            string4 = stringBuffer.substring(n - 1, n);
            if (!string4.equals("?") && !string4.equals("&")) {
                stringBuffer.append("&");
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append("=");
        try {
            stringBuffer.append(URLEncoder.encode(string3, ENCODING_SCHEME));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

