/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.http.StreamReader;
import com.jronimo.http.exceptions.ReadTimedOutException;
import com.jronimo.http.exceptions.RequestTooLongException;
import com.jronimo.http.exceptions.StreamBytesNotFoundException;
import com.jronimo.util.Logger;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

public final class HttpRequestBodyReader {
    private static final Logger logger = Logger.getLogger(HttpRequestBodyReader.class);
    private HttpServletRequest request;
    private ConfigStruct configStruct;

    public HttpRequestBodyReader(HttpServletRequest httpServletRequest, ConfigStruct configStruct) {
        this.request = httpServletRequest;
        this.configStruct = configStruct;
    }

    public Results execute() {
        Results results = null;
        StreamReader.ConfigStruct configStruct = null;
        StreamReader streamReader = null;
        Exception exception = null;
        try {
            if (this.request.getContentLength() > this.configStruct.maxHttpRequestLength) {
                throw new RequestTooLongException(this.request.getRemoteHost(), this.request.getContentLength(), this.configStruct.maxHttpRequestLength);
            }
            configStruct = new StreamReader.ConfigStruct();
            configStruct.numberOfBytesToRead = this.request.getContentLength();
            configStruct.readSleepInterval = this.configStruct.readSleepInterval;
            configStruct.bytesPerSecond = this.configStruct.bytesPerSecond;
            configStruct.minReadTimeout = this.configStruct.minReadTimeout;
            streamReader = new StreamReader((InputStream)this.request.getInputStream(), configStruct);
            streamReader.start();
            streamReader.join();
            if (streamReader.hasException()) {
                exception = streamReader.getException();
                if (exception instanceof StreamBytesNotFoundException) {
                    ((StreamBytesNotFoundException)exception).setIp(this.request.getRemoteHost());
                } else if (exception instanceof ReadTimedOutException) {
                    ((ReadTimedOutException)exception).setIp(this.request.getRemoteHost());
                }
            } else {
                results = new Results(this.request.getRemoteHost(), streamReader.getBytes());
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (results == null) {
            results = new Results(this.request.getRemoteHost(), exception);
        }
        return results;
    }

    public static final class Results {
        private String ip;
        private byte[] bytes;
        private Exception exception;

        Results(String string, byte[] byArray) {
            this.ip = string;
            this.bytes = byArray;
        }

        Results(String string, Exception exception) {
            this.ip = string;
            this.exception = exception;
        }

        public String getIp() {
            return this.ip;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static final class ConfigStruct {
        public int maxHttpRequestLength = 2048000;
        public int readSleepInterval = 100;
        public int bytesPerSecond = 3400;
        public int minReadTimeout = 18000;
    }
}

