/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.exceptions.BaseRuntimeException;
import com.jronimo.exceptions.BubbleUpException;
import com.jronimo.http.StreamReader;
import com.jronimo.http.UrlParts;
import com.jronimo.util.Logger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttp {
    private static final Logger logger = Logger.getLogger(AbstractHttp.class);
    private UrlParts urlParts;
    private int httpResponseCode;
    private byte[] returnedBytes;
    private Map<String, String> headers;

    public AbstractHttp(UrlParts urlParts) {
        this.urlParts = urlParts;
    }

    public boolean isHttpResponseOk() {
        return this.httpResponseCode == 200;
    }

    public byte[] getReturnedBytes() {
        return this.returnedBytes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] execute() {
        return this.execute(false);
    }

    public byte[] execute(boolean bl) {
        byte[] byArray = null;
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(this.urlParts.getProtocol(), this.urlParts.getHost(), this.urlParts.getPort(), this.urlParts.getPath());
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            this.configureConnection(httpURLConnection);
            httpURLConnection.connect();
            this.sendRequest(httpURLConnection);
            if (bl) {
                this.retrieveHeaders(httpURLConnection);
            }
            byArray = this.readResponse(httpURLConnection);
            this.returnedBytes = byArray;
        }
        catch (BaseRuntimeException baseRuntimeException) {
            throw baseRuntimeException;
        }
        catch (Exception exception) {
            throw new BubbleUpException(exception);
        }
        finally {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    protected abstract void configureConnection(HttpURLConnection var1) throws Exception;

    protected abstract void sendRequest(HttpURLConnection var1) throws Exception;

    private void retrieveHeaders(HttpURLConnection httpURLConnection) throws Exception {
        Map<String, List<String>> map = null;
        List<String> list = null;
        StringBuilder stringBuilder = null;
        try {
            map = httpURLConnection.getHeaderFields();
            this.headers = CollectionUtils.getOrderedMap(new HashMap(map.size()));
            for (String string : map.keySet()) {
                list = map.get(string);
                stringBuilder = new StringBuilder();
                for (String string2 : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(string2);
                }
                this.headers.put(string, stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    private byte[] readResponse(HttpURLConnection httpURLConnection) throws Exception {
        byte[] byArray = null;
        String string = null;
        Integer n = null;
        StreamReader.ConfigStruct configStruct = null;
        StreamReader streamReader = null;
        this.httpResponseCode = httpURLConnection.getResponseCode();
        string = httpURLConnection.getHeaderField("content-length");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        configStruct = new StreamReader.ConfigStruct();
        configStruct.numberOfBytesToRead = n;
        streamReader = new StreamReader(httpURLConnection.getInputStream(), configStruct);
        streamReader.start();
        streamReader.join();
        if (streamReader.hasException()) {
            throw streamReader.getException();
        }
        byArray = streamReader.getBytes();
        return byArray;
    }
}

