/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.exceptions;

import com.jronimo.exceptions.BaseRuntimeException;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.io.File;

public final class FileSystemException
extends BaseRuntimeException {
    public FileSystemException(String string) {
        super(string);
    }

    public FileSystemException(Throwable throwable) {
        super(throwable);
    }

    public FileSystemException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public static void assertFileExists(File file) {
        Assert.errorParam(!file.exists(), new ResourceTextPointer((Object)ResourceTextIdentifiers.FILE_DOES_NOT_EXIST, file.getPath()));
    }

    public static void assertDirectory(File file) {
        Assert.errorParam(!file.isDirectory(), new ResourceTextPointer((Object)ResourceTextIdentifiers.FILE_NOT_DIRECTORY, file.getPath()));
    }

    public static FileSystemException unexpectedFileSystemError() {
        FileSystemException fileSystemException = null;
        fileSystemException = FileSystemException.unexpectedFileSystemError(null);
        return fileSystemException;
    }

    public static FileSystemException unexpectedFileSystemError(Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string = null;
        string = ResourceText.getText((Object)ResourceTextIdentifiers.UNEXPECTED_FILE_SYSTEM_ERROR);
        fileSystemException = throwable == null ? new FileSystemException(string) : new FileSystemException(string, throwable);
        return fileSystemException;
    }

    public static FileSystemException couldNotCreateFolder(String string) {
        FileSystemException fileSystemException = null;
        fileSystemException = FileSystemException.couldNotCreateFolder(string, null);
        return fileSystemException;
    }

    public static FileSystemException couldNotCreateFolder(String string, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string2 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "filepath"));
        string2 = ResourceText.getText((Object)ResourceTextIdentifiers.COULD_NOT_CREATE_FOLDER, string);
        fileSystemException = throwable == null ? new FileSystemException(string2) : new FileSystemException(string2, throwable);
        return fileSystemException;
    }

    public static FileSystemException folderDoesNotExist(String string) {
        FileSystemException fileSystemException = null;
        fileSystemException = FileSystemException.folderDoesNotExist(string, null);
        return fileSystemException;
    }

    public static FileSystemException folderDoesNotExist(String string, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string2 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "filepath"));
        string2 = ResourceText.getText((Object)ResourceTextIdentifiers.FOLDER_DOES_NOT_EXIST, (Object[])new String[]{string});
        fileSystemException = throwable == null ? new FileSystemException(string2) : new FileSystemException(string2, throwable);
        return fileSystemException;
    }

    public static FileSystemException fileDoesNotExist(String string) {
        FileSystemException fileSystemException = null;
        fileSystemException = FileSystemException.fileDoesNotExist(string, null);
        return fileSystemException;
    }

    public static FileSystemException fileDoesNotExist(String string, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string2 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "filepath"));
        string2 = ResourceText.getText((Object)ResourceTextIdentifiers.FILE_DOES_NOT_EXIST, (Object[])new String[]{string});
        fileSystemException = throwable == null ? new FileSystemException(string2) : new FileSystemException(string2, throwable);
        return fileSystemException;
    }

    public static FileSystemException notDirectory(String string) {
        return FileSystemException.notDirectory(string, null);
    }

    public static FileSystemException notDirectory(String string, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string2 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "filepath"));
        string2 = ResourceText.getText((Object)ResourceTextIdentifiers.FILE_NOT_DIRECTORY, (Object[])new String[]{string});
        fileSystemException = FileSystemException.getInstance(string2, throwable);
        return fileSystemException;
    }

    public static FileSystemException notFile(String string) {
        return FileSystemException.notFile(string, null);
    }

    public static FileSystemException notFile(String string, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string2 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "filepath"));
        string2 = ResourceText.getText((Object)ResourceTextIdentifiers.FILE_NOT_FILE, (Object[])new String[]{string});
        fileSystemException = FileSystemException.getInstance(string2, throwable);
        return fileSystemException;
    }

    public static FileSystemException wrongExtension(String string, String string2) {
        return FileSystemException.wrongExtension(string, string2, null);
    }

    public static FileSystemException wrongExtension(String string, String string2, Throwable throwable) {
        FileSystemException fileSystemException = null;
        String string3 = null;
        Assert.errorParamMustNotBeNull("filepath", string2);
        string3 = ResourceText.getText((Object)ResourceTextIdentifiers.FILE_WRONG_EXTENSION, (Object[])new String[]{string, string2});
        fileSystemException = FileSystemException.getInstance(string3, throwable);
        return fileSystemException;
    }

    public static FileSystemException getInstance(String string, Throwable throwable) {
        return throwable == null ? new FileSystemException(string) : new FileSystemException(string, throwable);
    }
}

