/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.exceptions;

import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.sql.Timestamp;

public abstract class BaseException
extends Exception {
    private long timestamp = 0L;

    public BaseException(String string) {
        super(string);
        this.timestamp = System.currentTimeMillis();
    }

    public BaseException(Throwable throwable) {
        super(throwable);
        this.timestamp = System.currentTimeMillis();
    }

    public BaseException(String string, Throwable throwable) {
        super(string, throwable);
        this.timestamp = System.currentTimeMillis();
    }

    protected BaseException() {
    }

    protected static String getTitle(Class clazz) {
        return clazz.getSimpleName();
    }

    public Timestamp getTimestamp() {
        Timestamp timestamp = null;
        timestamp = new Timestamp(this.timestamp);
        return timestamp;
    }

    public XmlElement getXml() {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("exception");
        xmlElement.addElement("type").setText(this.getClass().getSimpleName());
        xmlElement.addElement("message").setText(this.getMessage());
        return xmlElement;
    }
}

