/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.fileservice;

import com.jronimo.engines.fileservice.FileInstructions;
import com.jronimo.engines.fileservice.FileService;
import com.jronimo.text.ResourceText;
import com.jronimo.util.EncryptionUtils;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import com.jronimo.webappengines.ResourceTextIdentifiers;
import com.jronimo.webappengines.core.SystemsContainerDeployment;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Files {
    private static final Logger logger = Logger.getLogger(Files.class);
    private String systemIdentifier;
    private String version;
    private String environment;
    private String systemHomeUrl;
    private boolean canWorkOffline;
    private Map<String, byte[]> kernelFiles;
    private Map<String, byte[]> appFiles;
    private File primaryKernelRoot;
    private File secondaryKernelRoot;
    private File primaryAppRoot;
    private File secondaryAppRoot;
    private Map<FileService.FileSetKey, byte[]> fileSetsXml;

    private Files(String string, String string2, String string3, String string4, boolean bl, Map<String, byte[]> map, Map<String, byte[]> map2, File file, File file2, File file3, File file4, Map<FileService.FileSetKey, byte[]> map3) {
        this.systemIdentifier = string;
        this.version = string2;
        this.environment = string3;
        this.systemHomeUrl = string4;
        this.canWorkOffline = bl;
        this.kernelFiles = map;
        this.appFiles = map2;
        this.primaryKernelRoot = file;
        this.secondaryKernelRoot = file2;
        this.primaryAppRoot = file3;
        this.secondaryAppRoot = file4;
        this.fileSetsXml = map3;
    }

    public static Files createInstance(File file, String string, String string2, String string3, String string4, boolean bl) throws Exception {
        Files files = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        FileInstructions fileInstructions = null;
        FileInstructions fileInstructions2 = null;
        HashMap<String, byte[]> hashMap = null;
        HashMap<String, byte[]> hashMap2 = null;
        Map<FileService.FileSetKey, byte[]> map = null;
        file2 = SystemsContainerDeployment.getInstance().getFileServiceKernelRoot();
        file3 = new File(file, "www-files/kernel-override");
        file4 = new File(file, "www-files/app");
        file5 = new File(file, "www-files/app-override");
        fileInstructions = FileInstructions.createInstance(file2, file3);
        fileInstructions2 = FileInstructions.createInstance(file4, file5);
        hashMap = new HashMap<String, byte[]>(fileInstructions.getPaths().size());
        hashMap2 = new HashMap<String, byte[]>(fileInstructions2.getPaths().size());
        Files.readRootFile(hashMap, file2, file3, "/index.html", string, string2, string3, string4, bl);
        Files.readRootFile(hashMap, file2, file3, "/applet.html", string, string2, string3, string4, bl);
        for (String string5 : fileInstructions.getPaths()) {
            Files.readFile(hashMap, file2, file3, string5);
        }
        for (String string5 : fileInstructions2.getPaths()) {
            Files.readFile(hashMap2, file4, file5, string5);
        }
        map = Files.assembleFileSetsXml(fileInstructions, fileInstructions2, hashMap, hashMap2);
        files = new Files(string, string2, string3, string4, bl, hashMap, hashMap2, file2, file3, file4, file5, map);
        return files;
    }

    private static Map<FileService.FileSetKey, byte[]> assembleFileSetsXml(FileInstructions fileInstructions, FileInstructions fileInstructions2, Map<String, byte[]> map, Map<String, byte[]> map2) throws Exception {
        HashMap<FileService.FileSetKey, byte[]> hashMap = null;
        String string = null;
        XmlElement xmlElement = null;
        hashMap = new HashMap<FileService.FileSetKey, byte[]>(10);
        string = "Large";
        xmlElement = Files.buildXmlElement(fileInstructions, fileInstructions2, map, map2, string);
        Files.assembleFileSetsXml(hashMap, xmlElement.toBasicString(), string);
        string = "Small";
        xmlElement = Files.buildXmlElement(fileInstructions, fileInstructions2, map, map2, string);
        Files.assembleFileSetsXml(hashMap, xmlElement.toBasicString(), string);
        return hashMap;
    }

    private static void assembleFileSetsXml(Map<FileService.FileSetKey, byte[]> map, String string, String string2) throws Exception {
        map.put(FileService.FileSetKey.get(string2, "WebBrowser"), Files.removeWbwContexts(string, new String[]{"applet", "app"}));
        map.put(FileService.FileSetKey.get(string2, "Applet"), Files.removeWbwContexts(string, new String[]{"web-browser", "app"}));
        map.put(FileService.FileSetKey.get(string2, "App"), Files.removeWbwContexts(string, new String[]{"web-browser", "applet"}));
    }

    private static byte[] removeWbwContexts(String string, String[] stringArray) throws Exception {
        byte[] byArray = null;
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.load(string);
        Files.removeWbwContexts(xmlElement, "kernel-files", stringArray);
        Files.removeWbwContexts(xmlElement, "app-files", stringArray);
        byArray = xmlElement.toBasicString().getBytes("UTF-8");
        return byArray;
    }

    private static void removeWbwContexts(XmlElement xmlElement, String string, String[] stringArray) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement2 = xmlElement.getElement(string + "/defaults");
        for (String string2 : stringArray) {
            xmlElement2.removeElement(string2);
        }
        for (XmlElement xmlElement3 : xmlElement.getElements(string + "/files")) {
            for (String string3 : stringArray) {
                xmlElement3.removeElement(string3);
            }
        }
    }

    private static XmlElement buildXmlElement(FileInstructions fileInstructions, FileInstructions fileInstructions2, Map<String, byte[]> map, Map<String, byte[]> map2, String string) throws Exception {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("files");
        Files.buildXmlElement(xmlElement.addElement("kernel-files"), fileInstructions, map, string);
        Files.buildXmlElement(xmlElement.addElement("app-files"), fileInstructions2, map2, string);
        return xmlElement;
    }

    private static void buildXmlElement(XmlElement xmlElement, FileInstructions fileInstructions, Map<String, byte[]> map, String string) throws Exception {
        EncryptionUtils.DigestStruct digestStruct = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        FileInstructions.InstructionsSet instructionsSet = null;
        digestStruct = new EncryptionUtils.DigestStruct();
        digestStruct.encoding = EncryptionUtils.Encoding.HEX;
        fileInstructions.getDefaultInstructionsSet().addXml(xmlElement.addElement("defaults"));
        xmlElement2 = xmlElement.addElement("files");
        for (String string2 : fileInstructions.getPaths()) {
            if (!string2.startsWith("/common/") && !string2.startsWith("/" + string + "/")) continue;
            instructionsSet = fileInstructions.getPathInstructionsSet(string2);
            xmlElement3 = xmlElement2.addElement("file");
            xmlElement3.addElement("path").setText(string2);
            digestStruct.bytes = map.get(string2);
            xmlElement3.addElement("version").setText(EncryptionUtils.createDigest(digestStruct));
            if (instructionsSet == null) continue;
            instructionsSet.addXml(xmlElement3);
        }
    }

    private static void readRootFile(Map<String, byte[]> map, File file, File file2, String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        map.put(string, Files.readRootFile(file, file2, string, string2, string3, string4, string5, bl));
    }

    private static byte[] readRootFile(File file, File file2, String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        byte[] byArray = null;
        File file3 = null;
        SystemsContainerDeployment systemsContainerDeployment = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        file3 = new File(file2, string);
        if (!file3.exists()) {
            file3 = new File(file, string);
        }
        systemsContainerDeployment = SystemsContainerDeployment.getInstance();
        stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(FileMethods.readTextFile(file3));
        stringWrapperWithVoidRegions.replaceAll("<% assemblyVersion %>", string3);
        stringWrapperWithVoidRegions.replaceAll("<% environment %>", string4);
        stringWrapperWithVoidRegions.replaceAll("<% systemHomeUrl %>", string5);
        stringWrapperWithVoidRegions.replaceAll("<% systemCoreUrl %>", systemsContainerDeployment.getWebApplicationUrl());
        stringWrapperWithVoidRegions.replaceAll("<% systemIdentifier %>", string2);
        stringWrapperWithVoidRegions.replaceAll("<% httpsAvailable %>", String.valueOf(systemsContainerDeployment.isHttpsAvailable()));
        stringWrapperWithVoidRegions.replaceAll("<% canWorkOffline %>", String.valueOf(bl));
        byArray = stringWrapperWithVoidRegions.toString().getBytes("UTF-8");
        return byArray;
    }

    private static void readFile(Map<String, byte[]> map, File file, File file2, String string) throws Exception {
        map.put(string, Files.readFile(file, file2, string));
    }

    private static byte[] readFile(File file, File file2, String string) throws Exception {
        byte[] byArray = null;
        File file3 = null;
        file3 = new File(file2, string);
        if (!file3.exists()) {
            file3 = new File(file, string);
        }
        byArray = FileMethods.readBinaryFile(file3);
        return byArray;
    }

    Map<FileService.FileSetKey, byte[]> getFileSetsXml() {
        Map<FileService.FileSetKey, byte[]> map = null;
        map = this.fileSetsXml;
        this.fileSetsXml = null;
        return map;
    }

    byte[] getFileBytes(String string, boolean bl) throws Exception {
        byte[] byArray = null;
        if (string != null) {
            this.checkFilePresence(string);
            if (bl) {
                if (string.startsWith("/kernel")) {
                    byArray = Files.readFile(this.primaryKernelRoot, this.secondaryKernelRoot, string.substring("/kernel".length()));
                } else if (string.equals("/index.html") || string.equals("/applet.html")) {
                    byArray = Files.readRootFile(this.primaryKernelRoot, this.secondaryKernelRoot, string, this.systemIdentifier, this.version, this.environment, this.systemHomeUrl, this.canWorkOffline);
                } else if (string.startsWith("/app")) {
                    byArray = Files.readFile(this.primaryAppRoot, this.secondaryAppRoot, string.substring("/app".length()));
                }
            } else if (string.startsWith("/kernel")) {
                byArray = this.kernelFiles.get(string.substring("/kernel".length()));
            } else if (string.equals("/index.html") || string.equals("/applet.html")) {
                byArray = this.kernelFiles.get(string);
            } else if (string.startsWith("/app")) {
                byArray = this.appFiles.get(string.substring("/app".length()));
            }
        }
        return byArray;
    }

    private void checkFilePresence(String string) {
        if (string.startsWith("/kernel")) {
            if (!this.kernelFiles.keySet().contains(string.substring("/kernel".length()))) {
                logger.warning(ResourceText.getText((Object)ResourceTextIdentifiers.FILE_ABSENCE_WARNING, (Object[])new String[]{string}));
            }
        } else if (string.startsWith("/app") && !this.appFiles.keySet().contains(string.substring("/app".length()))) {
            logger.warning(ResourceText.getText((Object)ResourceTextIdentifiers.FILE_ABSENCE_WARNING, (Object[])new String[]{string}));
        }
    }
}

