/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.fileservice;

import com.jronimo.engines.fileservice.Files;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.core.FileServiceRequest;
import com.jronimo.webappengines.core.SystemDeployment;
import com.jronimo.webappengines.core.exceptions.FileNotFoundException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.math.BigDecimal;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileService {
    private static final Logger logger = Logger.getLogger(FileService.class);
    private SystemDeployment systemDeployment;
    private File fileServiceRoot;
    private BigDecimal version;
    private Map<FileSetKey, byte[]> versionCheckResponses;
    private Files files;

    private FileService(SystemDeployment systemDeployment, File file, BigDecimal bigDecimal, Map<FileSetKey, byte[]> map, Files files) {
        this.systemDeployment = systemDeployment;
        this.fileServiceRoot = file;
        this.version = bigDecimal;
        this.versionCheckResponses = map;
        this.files = files;
    }

    public static FileService createInstance(SystemDeployment systemDeployment, File file) throws Exception {
        FileService fileService = null;
        XmlElement xmlElement = null;
        Files files = null;
        Map<FileSetKey, byte[]> map = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.load(new File(file, "FileService.xml"));
        files = Files.createInstance(file, systemDeployment.getSystemIdentifier(), xmlElement.getText("version"), new SimpleNameFormat(systemDeployment.getEnvironment().toString()).getCamelCase(), systemDeployment.getSystemHomeUrl(), xmlElement.getBoolean("can-work-offline"));
        map = files.getFileSetsXml();
        FileService.dress(map, xmlElement.getText("version"));
        xmlElement2 = XmlElementFactory.create("response");
        xmlElement2.addElement("up-to-date").setBoolean(true);
        map.put(FileSetKey.TRUE, xmlElement2.toBasicString().getBytes("UTF-8"));
        fileService = new FileService(systemDeployment, file, xmlElement.getBigDecimal("version"), map, files);
        return fileService;
    }

    private static void dress(Map<FileSetKey, byte[]> map, String string) throws Exception {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        for (FileSetKey fileSetKey : map.keySet()) {
            xmlElement = XmlElementFactory.create("response");
            xmlElement.addElement("up-to-date").setBoolean(false);
            xmlElement.addElement("version").setText(string);
            xmlElement2 = XmlElementFactory.load(map.get((Object)fileSetKey));
            xmlElement.addElement(xmlElement2);
            map.put(fileSetKey, xmlElement.toString().getBytes("UTF-8"));
        }
    }

    public byte[] processRequest(FileServiceRequest fileServiceRequest) throws Exception {
        byte[] byArray = null;
        if (fileServiceRequest.isVersionCheck()) {
            byArray = this.processVersionCheck(fileServiceRequest);
        } else if (fileServiceRequest.isFileRequest()) {
            byArray = this.processFileRequest(fileServiceRequest);
        }
        return byArray;
    }

    private byte[] processVersionCheck(FileServiceRequest fileServiceRequest) throws Exception {
        byte[] byArray = null;
        FileSetKey fileSetKey = null;
        if (this.version.floatValue() > Float.valueOf(fileServiceRequest.getVersion()).floatValue()) {
            fileSetKey = FileSetKey.get(fileServiceRequest.getRendition(), fileServiceRequest.getWbwContext());
            byArray = this.versionCheckResponses.get((Object)fileSetKey);
        } else {
            byArray = this.versionCheckResponses.get((Object)FileSetKey.TRUE);
        }
        return byArray;
    }

    private byte[] processFileRequest(FileServiceRequest fileServiceRequest) throws Exception {
        byte[] byArray = null;
        boolean bl = false;
        if (this.systemDeployment.getEnvironment() == Constants.SystemEnvironment.DEVELOPMENT) {
            bl = true;
        }
        if ((byArray = this.files.getFileBytes(fileServiceRequest.getFile(), bl)) == null) {
            throw new FileNotFoundException(fileServiceRequest.getFile());
        }
        return byArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileSetKey {
        TRUE("", ""),
        LARGE_WEB_BROWSER("Large", "WebBrowser"),
        LARGE_APPLET("Large", "Applet"),
        LARGE_APP("Large", "App"),
        MEDIUM_WEB_BROWSER("Medium", "WebBrowser"),
        MEDIUM_APPLET("Medium", "Applet"),
        MEDIUM_APP("Medium", "App"),
        SMALL_WEB_BROWSER("Small", "WebBrowser"),
        SMALL_APPLET("Small", "Applet"),
        SMALL_APP("Small", "App");

        private String rendition;
        private String wbwContext;

        private FileSetKey(String string2, String string3) {
            this.rendition = string2;
            this.wbwContext = string3;
        }

        public static FileSetKey get(String string, String string2) {
            FileSetKey fileSetKey = null;
            for (FileSetKey fileSetKey2 : FileSetKey.values()) {
                if (!fileSetKey2.rendition.equals(string) || !fileSetKey2.wbwContext.equals(string2)) continue;
                fileSetKey = fileSetKey2;
                break;
            }
            return fileSetKey;
        }
    }
}

