/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.fileservice;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileInstructions {
    private static final Logger logger = Logger.getLogger(FileInstructions.class);
    private InstructionsSet defaultInstructionsSet;
    private Map<String, InstructionsSet> pathInstructionsSets;

    private FileInstructions(InstructionsSet instructionsSet, Map<String, InstructionsSet> map) {
        this.defaultInstructionsSet = instructionsSet;
        this.pathInstructionsSets = map;
    }

    InstructionsSet getDefaultInstructionsSet() {
        return this.defaultInstructionsSet;
    }

    Collection<String> getPaths() {
        return this.pathInstructionsSets.keySet();
    }

    InstructionsSet getPathInstructionsSet(String string) {
        return this.pathInstructionsSets.get(string);
    }

    public static FileInstructions createInstance(File file, File file2) throws Exception {
        FileInstructions fileInstructions = null;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Map map = null;
        InstructionsSet instructionsSet = null;
        xmlElement = XmlElementFactory.load(new File(file, "file-instructions.xml"));
        xmlElement2 = XmlElementFactory.load(new File(file2, "file-instructions.xml"));
        nullFreeCollection = xmlElement.getOptionalElements("files/file");
        map = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        instructionsSet = FileInstructions.loadInstructionsSet(xmlElement.getElement("defaults"));
        instructionsSet.merge(FileInstructions.loadInstructionsSet(xmlElement2.getElement("defaults")));
        for (XmlElement xmlElement3 : nullFreeCollection) {
            FileInstructions.loadFile(xmlElement3, map);
        }
        for (XmlElement xmlElement3 : xmlElement2.getOptionalElements("files/file")) {
            FileInstructions.loadFile(xmlElement3, map);
        }
        fileInstructions = new FileInstructions(instructionsSet, map);
        return fileInstructions;
    }

    private static void loadFile(XmlElement xmlElement, Map<String, InstructionsSet> map) throws Exception {
        String string = null;
        InstructionsSet instructionsSet = null;
        InstructionsSet instructionsSet2 = null;
        string = xmlElement.getText("path");
        instructionsSet = FileInstructions.loadInstructionsSet(xmlElement);
        instructionsSet2 = map.get(string);
        if (instructionsSet2 == null) {
            map.put(string, instructionsSet);
        } else {
            instructionsSet2.merge(instructionsSet);
        }
    }

    private static InstructionsSet loadInstructionsSet(XmlElement xmlElement) throws Exception {
        InstructionsSet instructionsSet = null;
        instructionsSet = new InstructionsSet();
        if (xmlElement.hasElement("web-browser")) {
            instructionsSet.webBrowser = FileInstructions.loadInstructions(xmlElement.getElement("web-browser"));
        }
        if (xmlElement.hasElement("applet")) {
            instructionsSet.applet = FileInstructions.loadInstructions(xmlElement.getElement("applet"));
        }
        if (xmlElement.hasElement("app")) {
            instructionsSet.app = FileInstructions.loadInstructions(xmlElement.getElement("app"));
        }
        return instructionsSet;
    }

    private static Instructions loadInstructions(XmlElement xmlElement) throws Exception {
        Instructions instructions = null;
        instructions = new Instructions();
        instructions.activeDownload = xmlElement.getOptionalBoolean("active-download");
        instructions.activeLoad = xmlElement.getOptionalBoolean("active-load");
        if (xmlElement.hasElement("permanent-location")) {
            instructions.permanentLocation = Location.valueOf(new SimpleNameFormat(xmlElement.getText("permanent-location")).getUpperCase());
        }
        if (xmlElement.hasElement("runtime-location")) {
            instructions.runtimeLocation = Location.valueOf(new SimpleNameFormat(xmlElement.getText("runtime-location")).getUpperCase());
        }
        instructions.useHttps = xmlElement.getOptionalBoolean("use-https");
        return instructions;
    }

    static class Instructions {
        public Boolean activeDownload;
        public Boolean activeLoad;
        public Location permanentLocation;
        public Location runtimeLocation;
        public Boolean useHttps;

        Instructions() {
        }

        void merge(Instructions instructions) {
            if (instructions != null) {
                if (instructions.activeDownload != null) {
                    this.activeDownload = instructions.activeDownload;
                }
                if (instructions.activeLoad != null) {
                    this.activeLoad = instructions.activeLoad;
                }
                if (instructions.permanentLocation != null) {
                    this.permanentLocation = instructions.permanentLocation;
                }
                if (instructions.runtimeLocation != null) {
                    this.runtimeLocation = instructions.runtimeLocation;
                }
                if (instructions.useHttps != null) {
                    this.useHttps = instructions.useHttps;
                }
            }
        }
    }

    static class InstructionsSet {
        public Instructions webBrowser;
        public Instructions applet;
        public Instructions app;

        InstructionsSet() {
        }

        void merge(InstructionsSet instructionsSet) {
            if (instructionsSet != null) {
                if (this.webBrowser != null) {
                    this.webBrowser.merge(instructionsSet.webBrowser);
                }
                if (this.applet != null) {
                    this.applet.merge(instructionsSet.applet);
                }
                if (this.app != null) {
                    this.app.merge(instructionsSet.app);
                }
            }
        }

        void addXml(XmlElement xmlElement) {
            if (this.webBrowser != null) {
                this.addXml(xmlElement.addElement("web-browser"), this.webBrowser);
            }
            if (this.applet != null) {
                this.addXml(xmlElement.addElement("applet"), this.applet);
            }
            if (this.app != null) {
                this.addXml(xmlElement.addElement("app"), this.app);
            }
        }

        private void addXml(XmlElement xmlElement, Instructions instructions) {
            if (instructions.activeDownload != null) {
                xmlElement.addElement("active-download").setBoolean(instructions.activeDownload);
            }
            if (instructions.activeLoad != null) {
                xmlElement.addElement("active-load").setBoolean(instructions.activeLoad);
            }
            if (instructions.permanentLocation != null) {
                xmlElement.addElement("permanent-location").setText(new SimpleNameFormat(instructions.permanentLocation.toString()).getCamelCase());
            }
            if (instructions.runtimeLocation != null) {
                xmlElement.addElement("runtime-location").setText(new SimpleNameFormat(instructions.runtimeLocation.toString()).getCamelCase());
            }
            if (instructions.useHttps != null) {
                xmlElement.addElement("use-https").setBoolean(instructions.useHttps);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Location {
        SERVER,
        APPLET,
        APP,
        SESSION_STORAGE,
        PERMANENT_STORAGE,
        FILE_SYSTEM,
        MEMORY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Container {
        WEB_BROWSER,
        APPLET,
        APP;

    }
}

