/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.nameformat.SimpleNameFormat;
import java.io.File;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerationConfig {
    private String name;
    private String packageString;
    private String connectionProvider;
    private File[] files;
    private Collection<SrcLocationStruct> srcLocations;
    private File[] resultLocations;
    private Map<String, String> pluralOverrides;
    private String defaultResultFileName;

    public GenerationConfig(Struct struct) {
        this.name = struct.name;
        this.packageString = struct.packageString;
        this.connectionProvider = struct.connectionProvider;
        this.files = struct.files;
        this.srcLocations = struct.srcLocations;
        this.resultLocations = struct.resultLocations;
        this.pluralOverrides = struct.pluralOverrides;
        this.defaultResultFileName = "dbrep_" + new SimpleNameFormat(this.name).getCamelCase() + ".jar";
    }

    public String getName() {
        return this.name;
    }

    public String getPackageString() {
        return this.packageString;
    }

    public String getConnectionProvider() {
        return this.connectionProvider;
    }

    public String getDefaultResultFileName() {
        return this.defaultResultFileName;
    }

    public File[] getFiles() {
        return this.files;
    }

    public Collection<SrcLocationStruct> getSrcLocations() {
        return this.srcLocations;
    }

    public File[] getResultLocations() {
        return this.resultLocations;
    }

    public Map<String, String> getPluralOverrides() {
        return this.pluralOverrides;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append("this.name: " + this.name);
        stringBuffer.append("; this.defaultResultFileName: " + this.defaultResultFileName);
        stringBuffer.append("; this.files:");
        int n2 = this.files.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\n\t" + this.files[n]);
        }
        stringBuffer.append("; this.resultLocations:");
        n2 = this.resultLocations.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\n\t" + this.resultLocations[n]);
        }
        return stringBuffer.toString();
    }

    public static class SrcLocationStruct {
        public File directory;
        public Collection<String> exclusions;
    }

    public static class Struct {
        public String name;
        public String packageString;
        public String connectionProvider;
        public File[] files;
        public Collection<SrcLocationStruct> srcLocations;
        public File[] resultLocations;
        public Map<String, String> pluralOverrides;
    }
}

