/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.engines.dbrep.Field;

public final class FieldValue {
    private Field field;
    private Object value;
    private boolean isNull;

    public FieldValue(Field field, Object object) {
        this.field = field;
        this.value = object;
        this.isNull = object == null;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Byte getByte() {
        Byte by = null;
        long l = 0L;
        if (this.value != null) {
            l = this.getLongValue();
            by = (byte)l;
        }
        return by;
    }

    public Short getShort() {
        Short s = null;
        long l = 0L;
        if (this.value != null) {
            l = this.getLongValue();
            s = (short)l;
        }
        return s;
    }

    public Integer getInteger() {
        Integer n = null;
        long l = 0L;
        if (this.value != null) {
            l = this.getLongValue();
            n = (int)l;
        }
        return n;
    }

    public Long getLong() {
        Long l = null;
        long l2 = 0L;
        if (this.value != null) {
            l2 = this.getLongValue();
            l = l2;
        }
        return l;
    }

    public Float getFloat() {
        Float f = null;
        double d = 0.0;
        if (this.value != null) {
            d = this.getDoubleValue();
            f = Float.valueOf((float)d);
        }
        return f;
    }

    public Double getDouble() {
        Double d = null;
        double d2 = 0.0;
        if (this.value != null) {
            d2 = this.getDoubleValue();
            d = d2;
        }
        return d;
    }

    public String getString() {
        return (String)this.value;
    }

    public byte[] getBytes() {
        return (byte[])this.value;
    }

    private long getLongValue() {
        long l = 0L;
        if (this.value instanceof Long) {
            l = (Long)this.value;
        } else if (this.value instanceof Integer) {
            l = ((Integer)this.value).intValue();
        } else if (this.value instanceof Short) {
            l = ((Short)this.value).shortValue();
        } else if (this.value instanceof Byte) {
            l = ((Byte)this.value).byteValue();
        }
        return l;
    }

    private double getDoubleValue() {
        double d = 0.0;
        if (this.value instanceof Double) {
            d = (Double)this.value;
        } else if (this.value instanceof Float) {
            d = ((Float)this.value).floatValue();
        }
        return d;
    }
}

