/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.engines.dbrep.Field;
import com.jronimo.engines.dbrep.GenerationConfig;
import com.jronimo.engines.dbrep.ReplaceText;
import com.jronimo.engines.dbrep.Table;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Methods;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public final class EntityGenerator {
    private static Class[] classes = new Class[]{Field.class};
    private File generationRoot;
    private File srcDirectory;
    private GenerationConfig config;
    private Table table;
    private StringBuffer templateText = null;

    public EntityGenerator(Struct struct) {
        this.generationRoot = struct.generationRoot;
        this.srcDirectory = struct.srcDirectory;
        this.config = struct.config;
        this.table = struct.table;
    }

    public void execute() throws Exception {
        HashMap<String, String> hashMap = null;
        File file = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<package>", this.config.getPackageString());
        hashMap.put("<entity-name>", this.table.getEntityName());
        hashMap.put("<table-name>", this.table.getTableName());
        hashMap.put("<field-constants>", this.get("getFieldConstant"));
        hashMap.put("<field-name-constants>", this.get("getFieldNameConstant"));
        hashMap.put("<number-of-fields>", String.valueOf(this.table.getFields().size()));
        hashMap.put("<add-field-constants>", this.get("getAddFieldConstant"));
        hashMap.put("<field-getters>", this.get("getFieldGetter"));
        hashMap.put("<struct-field-assignments>", this.get("getStructFieldAssignment"));
        hashMap.put("<struct-fields>", this.get("getStructField"));
        file = new File(this.srcDirectory, this.table.getEntityName() + ".java");
        FileMethods.writeTextFile(file, ReplaceText.replaceText(this.generationRoot, "Entity.template", hashMap));
    }

    private String get(String string) throws Exception {
        StringBuffer stringBuffer = null;
        List<Field> list = null;
        String string2 = null;
        list = this.table.getFields();
        stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            string2 = (String)Methods.executeViaReflection(EntityGenerator.class, (Object)this, string, true, classes, new Object[]{list.get(i)});
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String getFieldConstant(Field field) throws Exception {
        String string = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-uppercase-name>", field.getUpperCaseName());
        hashMap.put("<field-db-type>", field.getType().getDbType());
        string = ReplaceText.replaceText(this.generationRoot, "FieldConstant.template", hashMap);
        return string;
    }

    private String getFieldNameConstant(Field field) throws Exception {
        String string = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-uppercase-name>", field.getUpperCaseName());
        string = ReplaceText.replaceText(this.generationRoot, "FieldNameConstant.template", hashMap);
        return string;
    }

    private String getAddFieldConstant(Field field) throws Exception {
        String string = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-uppercase-name>", field.getUpperCaseName());
        string = ReplaceText.replaceText(this.generationRoot, "AddFieldConstant.template", hashMap);
        return string;
    }

    private String getFieldGetter(Field field) throws Exception {
        String string = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-java-type>", field.getType().getJavaType());
        hashMap.put("<field-class-name>", field.getJavaClassName());
        hashMap.put("<field-variable-name>", field.getJavaVariableName());
        string = ReplaceText.replaceText(this.generationRoot, "FieldGetter.template", hashMap);
        return string;
    }

    private String getStructFieldAssignment(Field field) throws Exception {
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = null;
        string2 = field.getType().getJavaType();
        if (string2.equals("byte[]")) {
            string2 = "Bytes";
        }
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-variable-name>", field.getJavaVariableName());
        hashMap.put("<field-java-type>", string2);
        hashMap.put("<entity-name>", this.table.getEntityName());
        hashMap.put("<field-uppercase-name>", field.getUpperCaseName());
        string = ReplaceText.replaceText(this.generationRoot, "StructFieldAssignment.template", hashMap);
        return string;
    }

    private String getStructField(Field field) throws Exception {
        String string = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("<field-java-type>", field.getType().getJavaType());
        hashMap.put("<field-variable-name>", field.getJavaVariableName());
        string = ReplaceText.replaceText(this.generationRoot, "StructField.template", hashMap);
        return string;
    }

    public static class Struct {
        public File generationRoot;
        public File srcDirectory;
        public GenerationConfig config;
        public Table table;
    }
}

