/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.engines.dbrep.ConnectionProvider;
import com.jronimo.engines.dbrep.Field;
import com.jronimo.engines.dbrep.FieldValue;
import com.jronimo.engines.dbrep.OrderCriteria;
import com.jronimo.engines.dbrep.QueryCriteria;
import com.jronimo.engines.dbrep.Results;
import com.jronimo.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final Logger logger = Logger.getLogger(AbstractConnectionProvider.class);
    private ConnectionProvider provider;

    protected AbstractConnectionProvider(ConnectionProvider connectionProvider) {
        this.provider = connectionProvider;
    }

    @Override
    public Connection getConnection() {
        Connection connection = null;
        connection = this.provider.getConnection();
        return connection;
    }

    @Override
    public void returnConnection(Connection connection) {
        this.provider.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Results query(ConnectionProvider connectionProvider, String string, QueryCriteria queryCriteria, List<Field> list) throws Exception {
        Results results = null;
        List<FieldValue> list2 = null;
        List<OrderCriteria> list3 = null;
        StringBuffer stringBuffer = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Object var10_10 = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            list2 = queryCriteria.getFieldValues();
            list3 = queryCriteria.getOrderCriterias();
            stringBuffer = new StringBuffer("Select * From " + string);
            if (list2 != null && list2.size() > 0) {
                stringBuffer.append(" Where ");
                n = 0;
                for (FieldValue object : list2) {
                    if (n++ > 0) {
                        stringBuffer.append(" And ");
                    }
                    stringBuffer.append(object.getField().getUpperCaseName());
                    if (object.isNull()) {
                        stringBuffer.append(" Is Null");
                        continue;
                    }
                    stringBuffer.append(" = ?");
                }
            }
            if (list3 != null && list3.size() > 0) {
                stringBuffer.append(" Order By");
                for (OrderCriteria orderCriteria : list3) {
                    stringBuffer.append(" ");
                    stringBuffer.append(orderCriteria.getField().getUpperCaseName());
                    stringBuffer.append(orderCriteria.ascending() ? " Asc" : " Desc");
                    stringBuffer.append(",");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            connection = connectionProvider.getConnection();
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            if (list2 != null && list2.size() > 0) {
                n = 0;
                for (FieldValue fieldValue : list2) {
                    if (fieldValue.isNull()) continue;
                    if (fieldValue.getField().getType().isBoolean()) {
                        preparedStatement.setBoolean(++n, fieldValue.getBoolean());
                        continue;
                    }
                    if (fieldValue.getField().getType().isByte()) {
                        preparedStatement.setByte(++n, fieldValue.getByte());
                        continue;
                    }
                    if (fieldValue.getField().getType().isShort()) {
                        preparedStatement.setShort(++n, fieldValue.getShort());
                        continue;
                    }
                    if (fieldValue.getField().getType().isInteger()) {
                        preparedStatement.setInt(++n, fieldValue.getInteger());
                        continue;
                    }
                    if (fieldValue.getField().getType().isLong()) {
                        preparedStatement.setLong(++n, fieldValue.getLong());
                        continue;
                    }
                    if (fieldValue.getField().getType().isFloat()) {
                        preparedStatement.setFloat(++n, fieldValue.getFloat().floatValue());
                        continue;
                    }
                    if (fieldValue.getField().getType().isDouble()) {
                        preparedStatement.setDouble(++n, fieldValue.getDouble());
                        continue;
                    }
                    if (fieldValue.getField().getType().isString()) {
                        preparedStatement.setString(++n, fieldValue.getString());
                        continue;
                    }
                    if (!fieldValue.getField().getType().isByteArray()) continue;
                    preparedStatement.setBytes(++n, fieldValue.getBytes());
                }
            }
            resultSet = preparedStatement.executeQuery();
            results = new Results(resultSet, list);
        }
        catch (Throwable throwable) {
            AbstractConnectionProvider.close(resultSet);
            AbstractConnectionProvider.close(preparedStatement);
            connectionProvider.returnConnection(connection);
            throw throwable;
        }
        AbstractConnectionProvider.close(resultSet);
        AbstractConnectionProvider.close(preparedStatement);
        connectionProvider.returnConnection(connection);
        return results;
    }

    private static void close(ResultSet resultSet) {
        try {
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(PreparedStatement preparedStatement) {
        try {
            preparedStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

