/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.util;

import com.jronimo.engines.dataservice.ByteArray;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.MySqlType;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.util.Logger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class MySqlUtils {
    private static final Logger logger = Logger.getLogger(MySqlUtils.class);

    private MySqlUtils() {
    }

    static Object getCodeValue(DataType dataType, Constants.CodeType codeType, DataSourceFieldType dataSourceFieldType, Object object) {
        Object object2 = null;
        MySqlType mySqlType = null;
        ValueStruct valueStruct = null;
        mySqlType = (MySqlType)dataSourceFieldType.getUnderlyingType();
        switch (codeType) {
            case STRING: {
                object2 = object.toString();
                break;
            }
            case LONG: {
                object2 = Long.valueOf(object.toString());
                break;
            }
            case INTEGER: {
                object2 = Integer.valueOf(object.toString());
                break;
            }
            case SHORT: {
                object2 = Short.valueOf(object.toString());
                break;
            }
            case BYTE: {
                object2 = Byte.valueOf(object.toString());
                break;
            }
            case BIG_DECIMAL: {
                object2 = object;
                break;
            }
            case DOUBLE: {
                object2 = Double.valueOf(object.toString());
                break;
            }
            case FLOAT: {
                object2 = Float.valueOf(object.toString());
                break;
            }
            case BOOLEAN: {
                object2 = Integer.parseInt(object.toString()) == 1;
                break;
            }
            case DATE: {
                object2 = new com.jronimo.temporal.Date(object.toString());
                break;
            }
            case DATE_TIME: {
                if (dataType.isDateTime()) {
                    object2 = new DateTime(object.toString());
                    break;
                }
                if (!dataType.isTimestamp()) break;
                object2 = new DateTime(Long.valueOf(object.toString()));
                break;
            }
            case TIME_OF_DAY: {
                if (mySqlType.isTime()) {
                    object2 = new TimeOfDay(object.toString());
                    break;
                }
                valueStruct = new ValueStruct();
                valueStruct.millisecondValue = Long.valueOf(object.toString());
                object2 = new TimeOfDay(valueStruct);
                break;
            }
            case TIME: {
                if (mySqlType.isTime()) {
                    object2 = new com.jronimo.temporal.Time(object.toString());
                    break;
                }
                valueStruct = new ValueStruct();
                valueStruct.millisecondValue = Long.valueOf(object.toString());
                object2 = new com.jronimo.temporal.Time(valueStruct);
                break;
            }
            case TIMEZONE: {
                object2 = Timezone.getTimezone(Integer.valueOf(object.toString()));
                break;
            }
            case BYTE_ARRAY: {
                object2 = new ByteArray((byte[])object);
            }
        }
        return object2;
    }

    static Object getPersistenceSetValue(DataType dataType, DataSourceFieldType dataSourceFieldType, Object object, Object object2) {
        Object object3 = null;
        MySqlType mySqlType = null;
        mySqlType = (MySqlType)dataSourceFieldType.getUnderlyingType();
        if (dataType.isAutoNumber()) {
            object3 = null;
        } else if (object2 != null) {
            object3 = object2;
        } else if (dataType.isTimezone()) {
            object3 = (byte)((Timezone)object).getId();
        } else if (dataType.isWholeNumber1()) {
            object3 = Byte.valueOf(object.toString());
        } else if (dataType.isWholeNumber2()) {
            object3 = Short.valueOf(object.toString());
        } else if (dataType.isBlob()) {
            object3 = ((ByteArray)object).getBytes();
        } else if (dataType.isBoolean()) {
            object3 = (Boolean)object != false ? Byte.valueOf("1") : Byte.valueOf("0");
        } else if (dataType.isDate()) {
            object3 = Date.valueOf(object.toString());
        } else if (dataType.isDateTime()) {
            object3 = Timestamp.valueOf(object.toString());
        } else if (dataType.isTimestamp()) {
            object3 = ((DateTime)object).getTemporalValue();
        } else if (dataType.isTimeOfDay()) {
            if (dataSourceFieldType.isMySqlType()) {
                if (mySqlType.isTime()) {
                    object3 = Time.valueOf(object.toString());
                } else if (mySqlType.isInt()) {
                    object3 = (int)((TimeOfDay)object).getTemporalValue();
                } else if (mySqlType.isBigInt()) {
                    object3 = ((TimeOfDay)object).getTemporalValue();
                }
            }
        } else if (dataType.isTime()) {
            if (dataSourceFieldType.isMySqlType()) {
                if (mySqlType.isTime()) {
                    object3 = Time.valueOf(object.toString());
                } else if (mySqlType.isInt()) {
                    object3 = (int)((TimeOfDay)object).getTemporalValue();
                }
            }
        } else if (dataType.isGroupingId() || dataType.isForeignKeyMember() || dataType.isRefData() || dataType.isTextElement()) {
            if (dataSourceFieldType.isMySqlType()) {
                if (mySqlType.isTinyInt()) {
                    object3 = Byte.valueOf(object.toString());
                } else if (mySqlType.isSmallInt()) {
                    object3 = Short.valueOf(object.toString());
                } else if (mySqlType.isInt()) {
                    object3 = Integer.valueOf(object.toString());
                } else if (mySqlType.isBigInt()) {
                    object3 = Long.valueOf(object.toString());
                }
            }
        } else {
            object3 = object;
        }
        return object3;
    }
}

