/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.constraints.ValidationOutcome;
import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.Validator;
import com.jronimo.engines.dataservice.exceptions.RecordVersionException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedRecordGetException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.RecordPrimaryKey;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);

    Utils() {
    }

    static void close(Statement statement) {
        try {
            statement.close();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    static void checkRecordVersion(ResultSet resultSet, EntityOperationDetails entityOperationDetails) throws Exception {
        SystemField systemField = null;
        FieldValue fieldValue = null;
        systemField = entityOperationDetails.getEntity().getRecordVersionSystemField();
        fieldValue = FieldValue.createInstanceFromPersistenceValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), resultSet.getObject(systemField.getPersistenceIdentifier()));
        if (!fieldValue.equals(entityOperationDetails.getSubmittedRecordVersion())) {
            throw new RecordVersionException(entityOperationDetails, entityOperationDetails.getSubmittedRecordVersion().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XmlElement createReturnXml(Connection connection, EntityOperationDetails entityOperationDetails, String string, Map<RecordPrimaryKey, RecordPrimaryKey> map) throws Exception {
        XmlElement xmlElement = null;
        Set<Field> set = null;
        Set<SystemField> set2 = null;
        boolean bl = false;
        String string2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        RecordPrimaryKey recordPrimaryKey = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        XmlElement xmlElement5 = null;
        FieldValue fieldValue = null;
        try {
            set = entityOperationDetails.getReturnFields();
            set2 = entityOperationDetails.getReturnSystemFields();
            bl = entityOperationDetails.returnSecurityClauseIds();
            string2 = "Select * From " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            xmlElement = XmlElementFactory.create("operation-result");
            xmlElement.addElement("operation-id").setText(entityOperationDetails.getOperationId());
            xmlElement2 = xmlElement.addElement("entity-operation-result");
            xmlElement2.addElement("default-entity-type").setText(entityOperationDetails.getEntity().getName());
            block15: while (resultSet.next()) {
                recordPrimaryKey = new RecordPrimaryKey(resultSet, entityOperationDetails);
                if ((recordPrimaryKey = map.get(recordPrimaryKey)).getSecurityClauseSet(entityOperationDetails.getSystem()).isEmpty()) {
                    switch (entityOperationDetails.getOperation()) {
                        case LIST: {
                            continue block15;
                        }
                        case GET: {
                            throw new UnauthorizedRecordGetException(entityOperationDetails);
                        }
                    }
                }
                xmlElement3 = xmlElement2.addElement("entity");
                if (bl) {
                    xmlElement4 = xmlElement3.addElement("security-clause-ids");
                    xmlElement4.addElement("get").setText(recordPrimaryKey.getOperationSecurityClauseIdsAsString(Constants.EntityOperation.GET));
                    xmlElement4.addElement("update").setText(recordPrimaryKey.getOperationSecurityClauseIdsAsString(Constants.EntityOperation.UPDATE));
                    xmlElement4.addElement("delete").setText(recordPrimaryKey.getOperationSecurityClauseIdsAsString(Constants.EntityOperation.DELETE));
                }
                xmlElement5 = xmlElement3.addElement("data");
                for (Field field : set) {
                    if (!recordPrimaryKey.getSecurityClauseSet(entityOperationDetails.getSystem()).hasReadField(field.getName())) continue;
                    fieldValue = FieldValue.createInstanceFromPersistenceValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(entityOperationDetails.getEngine()), resultSet.getObject(field.getPersistenceIdentifier()));
                    xmlElement5.addElement(field.getName()).setText(fieldValue.getStringValue());
                }
                for (SystemField systemField : set2) {
                    fieldValue = FieldValue.createInstanceFromPersistenceValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), resultSet.getObject(systemField.getPersistenceIdentifier()));
                    xmlElement5.addElement(systemField.getName()).setText(fieldValue.getStringValue());
                }
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return xmlElement;
    }

    static XmlElement createReturnXmlForSuccessfulDelete(EntityOperationDetails entityOperationDetails) throws Exception {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("operation-result");
        xmlElement.addElement("operation-id").setText(entityOperationDetails.getOperationId());
        xmlElement2 = xmlElement.addElement("entity-operation-result");
        xmlElement2.addElement("success").setBoolean(true);
        return xmlElement;
    }

    static XmlElement createReturnXmlFromValidationOutcomes(EntityOperationDetails entityOperationDetails, ValidationOutcomes validationOutcomes) throws Exception {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("validation-errors");
        xmlElement.addElement("operation-id").setText(entityOperationDetails.getOperationId());
        for (ValidationOutcome validationOutcome : validationOutcomes.getFailures()) {
            xmlElement2 = xmlElement.addElement("validation-error");
            xmlElement2.addElement("field-name").setText(validationOutcome.getFieldName());
            xmlElement2.addElement("error-message").setText(validationOutcome.getErrorMessage());
        }
        return xmlElement;
    }

    static ValidationOutcomes callValidator(EntityOperationDetails entityOperationDetails, Set<Field> set, List<FieldValue> list) {
        ValidationOutcomes validationOutcomes = null;
        Map map = null;
        int n = -1;
        Validator validator = null;
        map = CollectionUtils.getOrderedMap(new HashMap(set.size()));
        for (Field field : set) {
            map.put(field.getName(), list.get(++n).getCodeValue());
        }
        validator = entityOperationDetails.getConstraintSet().getValidator();
        validationOutcomes = validator.validate(map);
        return validationOutcomes;
    }
}

