/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.exceptions.RecordNotFoundException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.RecordPrimaryKey;
import com.jronimo.engines.dataservice.operationsengine.rdbms.RdbmsUtils;
import com.jronimo.engines.dataservice.operationsengine.rdbms.ReadOperationSql;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.PrimaryKey;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.util.Logger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReadInitialQuery {
    private static final Logger logger = Logger.getLogger(ReadInitialQuery.class);
    private EntityOperationDetails operationDetails;
    private ReadOperationSql operationSql;
    private SystemConfiguration system = null;
    private Set<RecordPrimaryKey> results = CollectionUtils.getOrderedSet(new HashSet());

    ReadInitialQuery(EntityOperationDetails entityOperationDetails, ReadOperationSql readOperationSql) {
        this.operationDetails = entityOperationDetails;
        this.operationSql = readOperationSql;
        this.system = entityOperationDetails.getOperationContext().getDataServiceDeployment().getSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        RecordPrimaryKey recordPrimaryKey = null;
        try {
            preparedStatement = RdbmsUtils.getReadPreparedStatement(this.operationDetails, this.operationSql.getInitialQuerySql());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                recordPrimaryKey = new RecordPrimaryKey(resultSet, this.operationDetails);
                this.results.add(recordPrimaryKey);
            }
            if (this.operationDetails.getOperation() == Constants.EntityOperation.GET && this.results.size() == 0) {
                throw new RecordNotFoundException(this.operationDetails);
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean hasResults() {
        return !this.results.isEmpty();
    }

    public Set<RecordPrimaryKey> getResults() {
        return this.results;
    }

    public String getPrimaryKeyWhereClause() {
        return this.getPrimaryKeyWhereClause(this.results.size());
    }

    public String getPrimaryKeyWhereClause(int n) {
        String string = null;
        PrimaryKey primaryKey = null;
        primaryKey = this.operationDetails.getEntity().getPrimaryKey();
        string = primaryKey.getFieldCount() == 1 ? this.getPrimaryKeyWhereClauseIn(n, primaryKey.getSingleFieldName()) : this.getPrimaryKeyWhereClauseOr(n);
        return string;
    }

    private String getPrimaryKeyWhereClauseIn(int n, String string) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        stringBuilder = new StringBuilder();
        stringBuilder.append(" Where ");
        stringBuilder.append(string);
        stringBuilder.append(" In(");
        for (RecordPrimaryKey recordPrimaryKey : this.results) {
            if (n2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(recordPrimaryKey.getWhereClauseIn());
            if (++n2 != n) continue;
            break;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String getPrimaryKeyWhereClauseOr(int n) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        stringBuilder = new StringBuilder(" Where ");
        for (RecordPrimaryKey recordPrimaryKey : this.results) {
            if (n2 > 0) {
                stringBuilder.append(" Or ");
            }
            stringBuilder.append(recordPrimaryKey.getWhereClauseOr());
            if (++n2 != n) continue;
            break;
        }
        return stringBuilder.toString();
    }
}

