/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.ResourceTextIdentifiers;
import com.jronimo.engines.dataservice.exceptions.ValidationException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.rdbms.AbstractEntityOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.rdbms.RdbmsUtils;
import com.jronimo.engines.dataservice.operationsengine.rdbms.UpdateOperationSql;
import com.jronimo.engines.dataservice.operationsengine.rdbms.UpdateQuery;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.sql.Statement;

public class EntityUpdateOperationHandler
extends AbstractEntityOperationHandler {
    private static final Logger logger = Logger.getLogger(EntityUpdateOperationHandler.class);
    protected UpdateOperationSql operationSql;

    public EntityUpdateOperationHandler(EntityOperationDetails entityOperationDetails) {
        super(entityOperationDetails);
        this.operationSql = new UpdateOperationSql(entityOperationDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElement processOperation() throws Exception {
        XmlElement xmlElement = null;
        ValidationOutcomes validationOutcomes = null;
        UpdateQuery updateQuery = null;
        UpdateQuery updateQuery2 = null;
        validationOutcomes = this.operationDetails.getValidationOutcomes();
        if (validationOutcomes.passed()) {
            this.lock();
            try {
                updateQuery = new UpdateQuery(this.operationDetails, this.operationSql, true);
                updateQuery.execute();
                this.executeUpdate();
                updateQuery2 = new UpdateQuery(this.operationDetails, this.operationSql, false);
                updateQuery2.execute();
                xmlElement = updateQuery2.getReturnXml();
            }
            finally {
                this.unlock();
            }
        } else {
            throw new ValidationException(Utils.createReturnXmlFromValidationOutcomes(this.operationDetails, validationOutcomes));
        }
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate() throws Exception {
        String string = null;
        Statement statement = null;
        int n = 0;
        try {
            string = this.operationSql.getOperationSql();
            statement = RdbmsUtils.getUpdatePreparedStatement(this.operationDetails, string);
            n = statement.executeUpdate();
            if (n != 1) {
                throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.UNEXPECTED_MULTIPLE_RECORD_UPDATE, (Object[])new String[]{String.valueOf(n)}));
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

