/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.ResourceTextIdentifiers;
import com.jronimo.engines.dataservice.exceptions.ValidationException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.rdbms.AbstractEntityOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.rdbms.CreateOperationSql;
import com.jronimo.engines.dataservice.operationsengine.rdbms.CreateQuery;
import com.jronimo.engines.dataservice.operationsengine.rdbms.RdbmsUtils;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.sql.ResultSet;
import java.sql.Statement;

public class EntityCreateOperationHandler
extends AbstractEntityOperationHandler {
    private static final Logger logger = Logger.getLogger(EntityCreateOperationHandler.class);
    protected CreateOperationSql operationSql;

    public EntityCreateOperationHandler(EntityOperationDetails entityOperationDetails) {
        super(entityOperationDetails);
        this.operationSql = new CreateOperationSql(entityOperationDetails);
    }

    public XmlElement processOperation() throws Exception {
        XmlElement xmlElement = null;
        ValidationOutcomes validationOutcomes = null;
        CreateQuery createQuery = null;
        validationOutcomes = this.operationDetails.getValidationOutcomes();
        if (!validationOutcomes.passed()) {
            throw new ValidationException(Utils.createReturnXmlFromValidationOutcomes(this.operationDetails, validationOutcomes));
        }
        this.executeCreate();
        createQuery = new CreateQuery(this.operationDetails, this.operationSql);
        xmlElement = createQuery.execute();
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCreate() throws Exception {
        block13: {
            String string = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                string = this.operationSql.getOperationSql();
                statement = RdbmsUtils.getCreatePreparedStatement(this.operationDetails, string);
                statement.execute();
                if (this.operationDetails.getEntity().getPrimaryKey().getType() != Constants.PrimaryKeyType.AUTO_NUMBER) break block13;
                resultSet = statement.getGeneratedKeys();
                if (resultSet.next()) {
                    this.operationDetails.setNewCreateId(resultSet.getLong(1));
                    break block13;
                }
                throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.AUTO_NUMBER_VALUE_NOT_FOUND));
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

