/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.engines.dataservice.exceptions.RecordNotFoundException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedRecordDeleteException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.RecordPrimaryKey;
import com.jronimo.engines.dataservice.operationsengine.rdbms.DeleteOperationSql;
import com.jronimo.engines.dataservice.operationsengine.rdbms.RdbmsUtils;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

final class DeleteQuery {
    private static final Logger logger = Logger.getLogger(DeleteQuery.class);
    private EntityOperationDetails operationDetails;
    private DeleteOperationSql operationSql;
    private SystemConfiguration system = null;
    private String tempTableName;
    private Connection connection;
    private RecordPrimaryKey recordPrimaryKey;
    private Map<Field, Object> keyFieldValues = new HashMap<Field, Object>(3);
    private XmlElement returnXml;

    DeleteQuery(EntityOperationDetails entityOperationDetails, DeleteOperationSql deleteOperationSql) {
        this.operationDetails = entityOperationDetails;
        this.operationSql = deleteOperationSql;
        this.system = entityOperationDetails.getOperationContext().getDataServiceDeployment().getSystem();
        this.tempTableName = entityOperationDetails.getEntity().getName() + "_" + DateUtils.getUniqueTimestamp();
    }

    public XmlElement getReturnXml() {
        return this.returnXml;
    }

    XmlElement execute() throws Exception {
        XmlElement xmlElement = null;
        this.connection = this.operationDetails.getOperationContext().getTransactionRdbmsConnection(this.operationDetails.getEntityDataSource().name);
        this.createTempTable();
        this.selectIntoTempTable();
        this.marshalResults();
        this.applySecurityClauseSet();
        xmlElement = this.createReturnXml();
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempTable() throws Exception {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(this.operationSql.getCreateTempTableSql(this.tempTableName));
            this.operationDetails.getOperationContext().addTempTableForDeletion(this.connection, this.operationSql.getSchemaPortion() + this.tempTableName);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectIntoTempTable() throws Exception {
        String string = null;
        Statement statement = null;
        try {
            string = this.operationSql.getSelectIntoTempTableSql(this.tempTableName);
            statement = RdbmsUtils.getUpdateInitialPreparedStatement(this.operationDetails, string);
            statement.execute();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalResults() throws Exception {
        block13: {
            String string = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                string = "Select * From " + this.tempTableName;
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    this.recordPrimaryKey = new RecordPrimaryKey(resultSet, this.operationDetails);
                    if (this.operationDetails.getEntity().hasRecordVersionSystemField()) {
                        Utils.checkRecordVersion(resultSet, this.operationDetails);
                    }
                    break block13;
                }
                throw new RecordNotFoundException(this.operationDetails);
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void applySecurityClauseSet() throws Exception {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.operationDetails.getPrimarySecurityClauseSet().getSecurityClauses()) {
            this.applySecurityClauseSet(entityPermissionSecurityClause);
        }
        if (this.recordPrimaryKey.getSecurityClauseSet(this.system).isEmpty()) {
            throw new UnauthorizedRecordDeleteException(this.operationDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySecurityClauseSet(EntityPermissionSecurityClause entityPermissionSecurityClause) throws Exception {
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            string = this.operationSql.getSelectFromTempTableSql(this.tempTableName, entityPermissionSecurityClause);
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                this.recordPrimaryKey.addSecurityClauseId(entityPermissionSecurityClause.getId());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private XmlElement createReturnXml() throws Exception {
        XmlElement xmlElement = null;
        HashMap<RecordPrimaryKey, RecordPrimaryKey> hashMap = null;
        hashMap = new HashMap<RecordPrimaryKey, RecordPrimaryKey>(1);
        hashMap.put(this.recordPrimaryKey, this.recordPrimaryKey);
        xmlElement = Utils.createReturnXmlForSuccessfulDelete(this.operationDetails);
        return xmlElement;
    }
}

