/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.engines.dataservice.Constants;
import com.jronimo.engines.dataservice.ResourceTextIdentifiers;
import com.jronimo.engines.dataservice.exceptions.DataServiceException;
import com.jronimo.engines.dataservice.exceptions.PermissionException;
import com.jronimo.engines.dataservice.exceptions.ValidationException;
import com.jronimo.engines.dataservice.operationsengine.BusinessObjectOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.EntityCreateOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.EntityDeleteOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.EntityGetOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.EntityListOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.EntityUpdateOperationHandler;
import com.jronimo.engines.dataservice.operationsengine.OperationContext;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.exceptions.ClientInteractionException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class OperationsManager {
    private static final Logger logger = Logger.getLogger(OperationsManager.class);

    public XmlElement processOperation(OperationContext operationContext, XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Constants.OperationType operationType = null;
        int n = 0;
        try {
            nullFreeCollection = xmlElement.getOptionalElements("data-service/operation");
            for (XmlElement xmlElement3 : nullFreeCollection) {
                operationContext.setOperationIndex(++n);
                if (xmlElement3.hasElement("entity-operation")) {
                    operationType = Constants.OperationType.ENTITY;
                } else if (xmlElement3.hasElement("business-object-operation")) {
                    operationType = Constants.OperationType.BUSINESS_OBJECT;
                } else {
                    throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.OPERATION_ELEMENT_NOT_FOUND));
                }
                xmlElement2 = XmlElementFactory.create("data-service");
                switch (operationType) {
                    case ENTITY: {
                        xmlElement2.addElement(this.processEntityOperation(operationContext, xmlElement3));
                        break;
                    }
                    case BUSINESS_OBJECT: {
                        xmlElement2.addElement(this.processBusinessObjectOperation(operationContext, xmlElement3));
                    }
                }
            }
            operationContext.commit();
        }
        catch (Exception exception) {
            operationContext.rollback();
            xmlElement2 = this.handleError(exception);
        }
        return xmlElement2;
    }

    private XmlElement processEntityOperation(OperationContext operationContext, XmlElement xmlElement) throws Exception {
        XmlElement xmlElement2 = null;
        EntityOperationDetails entityOperationDetails = null;
        entityOperationDetails = new EntityOperationDetails(operationContext, xmlElement);
        switch (entityOperationDetails.getOperation()) {
            case LIST: {
                xmlElement2 = new EntityListOperationHandler(operationContext, entityOperationDetails).processOperation();
                break;
            }
            case GET: {
                xmlElement2 = new EntityGetOperationHandler(operationContext, entityOperationDetails).processOperation();
                break;
            }
            case CREATE: {
                xmlElement2 = new EntityCreateOperationHandler(operationContext, entityOperationDetails).processOperation();
                break;
            }
            case UPDATE: {
                xmlElement2 = new EntityUpdateOperationHandler(operationContext, entityOperationDetails).processOperation();
                break;
            }
            case DELETE: {
                xmlElement2 = new EntityDeleteOperationHandler(operationContext, entityOperationDetails).processOperation();
            }
        }
        return xmlElement2;
    }

    private XmlElement processBusinessObjectOperation(OperationContext operationContext, XmlElement xmlElement) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement2 = new BusinessObjectOperationHandler(operationContext, xmlElement).processOperation();
        return xmlElement2;
    }

    private XmlElement handleError(Exception exception) {
        XmlElement xmlElement = null;
        if (exception instanceof PermissionException) {
            // empty if block
        }
        if (exception instanceof ValidationException) {
            xmlElement = ((ValidationException)exception).getElement();
        } else if (exception instanceof DataServiceException) {
            xmlElement = this.handleDataServiceException((DataServiceException)exception);
        } else {
            if (exception instanceof ClientInteractionException) {
                throw (ClientInteractionException)exception;
            }
            if (exception instanceof UnexpectedErrorException) {
                throw (UnexpectedErrorException)exception;
            }
            throw new UnexpectedErrorException(exception);
        }
        return xmlElement;
    }

    private XmlElement handleDataServiceException(DataServiceException dataServiceException) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        String string = null;
        try {
            xmlElement = XmlElementFactory.create("error");
            xmlElement2 = xmlElement.addElement("exception");
            if (dataServiceException != null) {
                string = dataServiceException.getMessage();
                xmlElement2.addElement("type").setText(dataServiceException.getClass().getSimpleName());
                xmlElement2.addElement("message").setText(string == null ? "" : string);
                xmlElement2.addElement("operation-id").setText(dataServiceException.getOperationId());
                xmlElement2.addElement("target").setText(dataServiceException.getTarget());
                xmlElement2.addElement("operation").setText(dataServiceException.getOperation());
                logger.error(dataServiceException, false);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return xmlElement;
    }
}

