/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine;

import com.jronimo.engines.dataservice.DataService;
import com.jronimo.engines.dataservice.UserSecurityContext;
import com.jronimo.internationalization.Language;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Session;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class OperationContext {
    private static final Logger logger = Logger.getLogger(OperationContext.class);
    private DataService dataServiceDeployment;
    private Session session;
    private int operationIndex;
    private Map<String, Connection> rdbmsConnections = new HashMap<String, Connection>(1);
    private Map<Connection, Set<String>> tempTables = new HashMap<Connection, Set<String>>(1);

    public OperationContext(DataService dataService, Session session) {
        this.dataServiceDeployment = dataService;
        this.session = session;
    }

    public DataService getDataServiceDeployment() {
        return this.dataServiceDeployment;
    }

    public UserSecurityContext getUserSecurityContext() {
        return this.session.getUserSecurityContext();
    }

    public Language getLanguage() {
        return this.session.getLanguage();
    }

    public Locale getLocale() {
        return this.session.getLocale();
    }

    public int getSystemTimezone() {
        return this.dataServiceDeployment.getSystemTimezone().getId();
    }

    public boolean hasWorkflowContext() {
        return false;
    }

    public void setOperationIndex(int n) {
        this.operationIndex = n;
    }

    public int getOperationIndex() {
        return this.operationIndex;
    }

    public synchronized Connection getStandaloneRdbmsConnection(String string) throws Exception {
        Connection connection = null;
        connection = this.dataServiceDeployment.getRdbmsConnection(string);
        return connection;
    }

    public void returnStandaloneConnection(Connection connection) {
        this.returnConnection(connection);
    }

    public synchronized Connection getTransactionRdbmsConnection(String string) throws Exception {
        Connection connection = null;
        connection = this.rdbmsConnections.get(string);
        if (connection == null) {
            connection = this.dataServiceDeployment.getRdbmsConnection(string);
            this.rdbmsConnections.put(string, connection);
            this.tempTables.put(connection, new HashSet(2));
        }
        return connection;
    }

    public void commit() throws Exception {
        for (Connection connection : this.rdbmsConnections.values()) {
            connection.commit();
            this.deleteTempTables(connection);
        }
        this.returnConnections();
    }

    public void rollback() {
        for (Connection connection : this.rdbmsConnections.values()) {
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                logger.error(exception);
            }
        }
        this.returnConnections();
    }

    private void returnConnections() {
        for (Connection connection : this.rdbmsConnections.values()) {
            this.returnConnection(connection);
        }
    }

    private void returnConnection(Connection connection) {
        try {
            connection.rollback();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void addTempTableForDeletion(Connection connection, String string) {
        this.tempTables.get(connection).add(string);
    }

    private void deleteTempTables(Connection connection) {
        for (String string : this.tempTables.get(connection)) {
            this.deleteTempTable(connection, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTempTable(Connection connection, String string) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("Drop Table " + string);
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

