/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.constraints.Constraint;
import com.jronimo.constraints.Constraints;
import com.jronimo.constraints.ValidationOutcome;
import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.exceptions.IncompatibleFieldValueException;
import com.jronimo.engines.dataservice.exceptions.NullDirectiveNotPermittedException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedEntityException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedEntityOperationException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedReturnFieldException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedUpdateFieldException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedWhereFieldException;
import com.jronimo.engines.dataservice.exceptions.UnrecognizedFieldException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SecurityClauseSet;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityOperationUtils {
    private static final Logger logger = Logger.getLogger(EntityOperationUtils.class);

    private EntityOperationUtils() {
    }

    static FieldsAndValues getFieldsWithValues(EntityOperationDetails entityOperationDetails, Collection<XmlElement> collection, Constants.DataSourceEngine dataSourceEngine, Entity entity, Collection<Constants.NullDirective> collection2, boolean bl) throws Exception {
        FieldsAndValues fieldsAndValues = null;
        String string = null;
        Field field = null;
        fieldsAndValues = new FieldsAndValues();
        for (XmlElement xmlElement : collection) {
            string = xmlElement.getText("name");
            field = entity.getField(string);
            if (field == null) {
                field = entity.getSystemField(string);
                if (field == null) {
                    throw new UnrecognizedFieldException(entityOperationDetails, string);
                }
                fieldsAndValues.systemFields.add((SystemField)field);
                fieldsAndValues.systemFieldValues.add(EntityOperationUtils.getFieldValue(entityOperationDetails, xmlElement, field, dataSourceEngine, collection2, bl));
                continue;
            }
            fieldsAndValues.fields.add(field);
            fieldsAndValues.values.add(EntityOperationUtils.getFieldValue(entityOperationDetails, xmlElement, field, dataSourceEngine, collection2, bl));
        }
        return fieldsAndValues;
    }

    private static FieldValue getFieldValue(EntityOperationDetails entityOperationDetails, XmlElement xmlElement, Field field, Constants.DataSourceEngine dataSourceEngine, Collection<Constants.NullDirective> collection, boolean bl) throws Exception {
        FieldValue fieldValue = null;
        XmlElement xmlElement2 = null;
        String string = null;
        Constants.NullDirective nullDirective = null;
        DataType dataType = null;
        Constants.CodeType codeType = null;
        DataSourceFieldType dataSourceFieldType = null;
        xmlElement2 = xmlElement.getElement("value");
        string = xmlElement2.getText();
        nullDirective = Constants.NullDirective.get(string);
        if (nullDirective != null) {
            if (!collection.contains((Object)nullDirective)) {
                throw new NullDirectiveNotPermittedException(entityOperationDetails, xmlElement2.getPath(), string);
            }
            if (bl) {
                string = null;
            }
        }
        try {
            dataType = field.getDataType();
            codeType = field.getCodeType();
            dataSourceFieldType = field.getDataSourceFieldType(dataSourceEngine);
            fieldValue = FieldValue.createInstanceFromStringValue(dataType, codeType, dataSourceFieldType, string);
        }
        catch (Exception exception) {
            throw new IncompatibleFieldValueException(entityOperationDetails, field.getName(), xmlElement.getPath());
        }
        return fieldValue;
    }

    static Set<Field> getReturnFields(EntityOperationDetails entityOperationDetails, Collection<XmlElement> collection, Entity entity) throws Exception {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(collection.size()));
        for (XmlElement xmlElement : collection) {
            set.add(EntityOperationUtils.getReturnField(entityOperationDetails, xmlElement, entity));
        }
        return set;
    }

    private static Field getReturnField(EntityOperationDetails entityOperationDetails, XmlElement xmlElement, Entity entity) throws Exception {
        Field field = null;
        String string = null;
        string = xmlElement.getText();
        field = entity.getField(string);
        if (field == null) {
            throw new UnrecognizedFieldException(entityOperationDetails, string);
        }
        return field;
    }

    static boolean checkFields(List<String> list, List<String> list2) {
        boolean bl = false;
        if (list.size() == list2.size()) {
            for (String string : list2) {
                list.remove(string);
            }
            bl = list.size() == 0;
        }
        return bl;
    }

    static SecurityClauseSet getSecurityClauseSet(EntityOperationDetails entityOperationDetails, Set<SystemRole> set, Entity entity, Constants.EntityOperation entityOperation, List<Field> list, Set<Field> set2, Set<Field> set3, boolean bl) {
        return EntityOperationUtils.getSecurityClauseSet(entityOperationDetails, set, entity, entityOperation, list, set2, set3, bl, true);
    }

    static SecurityClauseSet getSecurityClauseSet(EntityOperationDetails entityOperationDetails, Set<SystemRole> set, Entity entity, Constants.EntityOperation entityOperation) {
        return EntityOperationUtils.getSecurityClauseSet(entityOperationDetails, set, entity, entityOperation, null, null, null, false, false);
    }

    private static SecurityClauseSet getSecurityClauseSet(EntityOperationDetails entityOperationDetails, Set<SystemRole> set, Entity entity, Constants.EntityOperation entityOperation, List<Field> list, Set<Field> set2, Set<Field> set3, boolean bl, boolean bl2) {
        SecurityClauseSet securityClauseSet = null;
        Set set4 = null;
        ArrayList<SecurityClauseSet> arrayList = null;
        set4 = CollectionUtils.getOrderedSet(new HashSet(set.size()));
        for (SystemRole object : set) {
            if (!object.hasEntityAccess(entity.getName())) continue;
            set4.add(object);
        }
        if (set4.isEmpty() && bl2) {
            throw new UnauthorizedEntityException(entityOperationDetails);
        }
        arrayList = new ArrayList<SecurityClauseSet>(2);
        for (SystemRole systemRole : set4) {
            arrayList.add(systemRole.getSecurityClauseSet(entity.getName(), entityOperation));
        }
        securityClauseSet = new SecurityClauseSet(arrayList);
        if (securityClauseSet.isEmpty() && bl2) {
            throw new UnauthorizedEntityOperationException(entityOperationDetails);
        }
        if (!securityClauseSet.isEmpty() && list != null) {
            for (Field field : list) {
                securityClauseSet.eliminateBasedOnReadField(field.getName());
                if (!securityClauseSet.isEmpty() || !bl2) continue;
                throw new UnauthorizedWhereFieldException(entityOperationDetails, field.getName());
            }
        }
        if (!securityClauseSet.isEmpty() && set2 != null) {
            for (Field field : set2) {
                switch (entityOperation) {
                    case CREATE: {
                        securityClauseSet.eliminateBasedOnCreateField(field.getName());
                        break;
                    }
                    case UPDATE: {
                        securityClauseSet.eliminateBasedOnUpdateField(field.getName());
                    }
                }
                if (!securityClauseSet.isEmpty() || !bl2) continue;
                throw new UnauthorizedUpdateFieldException(entityOperationDetails, field.getName());
            }
        }
        if (!securityClauseSet.isEmpty() && set3 != null && bl) {
            for (Field field : set3) {
                securityClauseSet.eliminateBasedOnReadField(field.getName());
                if (!securityClauseSet.isEmpty() || !bl2) continue;
                throw new UnauthorizedReturnFieldException(entityOperationDetails, field.getName());
            }
        }
        return securityClauseSet;
    }

    public static String assemblePrimaryKeyValuesString(EntityOperationDetails entityOperationDetails) {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder();
        for (Field field : entityOperationDetails.getEntity().getPrimaryKey().getFields(entityOperationDetails.getEntity())) {
            if (++n > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(field.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(entityOperationDetails.getWhereFieldValues().get(entityOperationDetails.getWhereFields().indexOf(field)));
        }
        return stringBuilder.toString();
    }

    public static ValidationOutcomes validate(EntityOperationDetails entityOperationDetails, Collection<Field> collection, List<FieldValue> list) {
        ValidationOutcomes validationOutcomes = null;
        ValidationOutcome validationOutcome = null;
        int n = -1;
        validationOutcomes = new ValidationOutcomes();
        for (Field field : collection) {
            validationOutcome = EntityOperationUtils.validate(entityOperationDetails, field, list.get(++n));
            if (validationOutcome == null) continue;
            validationOutcomes.add(validationOutcome);
        }
        return validationOutcomes;
    }

    private static ValidationOutcome validate(EntityOperationDetails entityOperationDetails, Field field, FieldValue fieldValue) {
        ValidationOutcome validationOutcome = null;
        Constraint.ConstraintType constraintType = null;
        Constraint.ConstraintCallStruct constraintCallStruct = null;
        Constraint.ConstraintCallStruct constraintCallStruct2 = null;
        Constraint constraint = null;
        switch (field.getBroadType()) {
            case WHOLE_NUMBER: 
            case DECIMAL_NUMBER: 
            case BOOLEAN: 
            case BINARY: {
                constraintType = Constraint.ConstraintType.valueOf(field.getBroadType().toString());
                break;
            }
            case TEXT: {
                constraintType = Constraint.ConstraintType.STRING;
                break;
            }
            default: {
                constraintType = field.getDataType().isTimestamp() ? Constraint.ConstraintType.DATE_TIME : Constraint.ConstraintType.valueOf(new SimpleNameFormat(field.getDataType().getName()).getUpperCase());
            }
        }
        constraintCallStruct = new Constraint.ConstraintCallStruct();
        constraintCallStruct.fieldName = field.getDisplayName();
        constraintCallStruct.value = fieldValue.getCodeValue();
        constraintCallStruct.language = entityOperationDetails.getOperationContext().getLanguage();
        constraintCallStruct.locale = entityOperationDetails.getOperationContext().getLocale();
        for (ConstraintSet.Constraint constraint2 : entityOperationDetails.getConstraintSet().getConstraints(field.getName())) {
            constraint = Constraints.getInstance().getConstraint(constraintType, constraint2.getName());
            constraintCallStruct2 = constraintCallStruct.cloneInstance();
            if (constraint2.hasValue()) {
                constraintCallStruct2.constraintValue = constraint2.getCodeValue();
            } else if (constraint2.hasValues()) {
                constraintCallStruct2.constraintValues = constraint2.getCodeValues();
            }
            if (constraint2.hasAdditionalUseTimezones()) {
                constraintCallStruct2.useTimezones = constraint2.getAdditionalUseTimezones();
            }
            if (!constraint.requiresNonNullValue() || constraintCallStruct.value != null) {
                validationOutcome = constraint.execute(constraintCallStruct2);
            }
            if (validationOutcome == null || validationOutcome.passed()) continue;
            break;
        }
        if (validationOutcome != null && validationOutcome.passed()) {
            validationOutcome = null;
        }
        return validationOutcome;
    }

    public static class FieldsAndValues {
        public List<Field> fields = new ArrayList<Field>();
        public List<FieldValue> values = new ArrayList<FieldValue>();
        public List<SystemField> systemFields = new ArrayList<SystemField>(1);
        public List<FieldValue> systemFieldValues = new ArrayList<FieldValue>(1);
    }
}

