/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.Methods;
import com.jronimo.engines.dataservice.exceptions.DuplicateUpdateFieldException;
import com.jronimo.engines.dataservice.exceptions.PrimaryKeyNullValueException;
import com.jronimo.engines.dataservice.exceptions.PrimaryKeyUpdateException;
import com.jronimo.engines.dataservice.exceptions.PrimaryKeyWhereFieldsRequiredException;
import com.jronimo.engines.dataservice.exceptions.RecordVersionNotSpecifiedException;
import com.jronimo.engines.dataservice.exceptions.SystemFieldUpdateException;
import com.jronimo.engines.dataservice.exceptions.SystemFieldWhereFieldException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedSystemRoleException;
import com.jronimo.engines.dataservice.exceptions.UnrecognizedEntityException;
import com.jronimo.engines.dataservice.exceptions.UnrecognizedSystemRoleException;
import com.jronimo.engines.dataservice.exceptions.UnsupportedEntityOperationException;
import com.jronimo.engines.dataservice.exceptions.UnsupportedReturnFieldException;
import com.jronimo.engines.dataservice.exceptions.WhereFieldsException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationUtils;
import com.jronimo.engines.dataservice.operationsengine.OperationContext;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Key;
import com.jronimo.systemconfiguration.SecurityClauseSet;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.exceptions.ClientInteractionException;
import com.jronimo.xml.XmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityOperationDetails {
    private static final Logger logger = Logger.getLogger(EntityOperationDetails.class);
    private OperationContext operationContext;
    private XmlElement operationElement;
    private SystemConfiguration system;
    private String operationId;
    private Set<SystemRole> systemRoles;
    private Constants.EntityOperation operation;
    private boolean returnSecurityClauseIds;
    private DataSource systemDataSource;
    private Entity.DataSource entityDataSource;
    private Constants.DataSourceEngine engine;
    private Entity entity;
    private ConstraintSet constraintSet;
    private Collection<Constants.NullDirective> allowableWhereNullDirectives;
    private List<Field> whereFields;
    private List<FieldValue> whereFieldValues;
    private FieldValue submittedRecordVersion;
    private Set<Field> updateFields;
    private List<FieldValue> updateFieldValues;
    private Set<Field> returnFields;
    private boolean returnFieldsAreExplicit;
    private Set<Field> keyFields;
    private Set<SystemField> returnSystemFields = CollectionUtils.getOrderedSet(new HashSet(6));
    private ValidationOutcomes validationOutcomes;
    private SecurityClauseSet primarySecurityClauseSet;
    private SecurityClauseSet otherSecurityClauseSet;
    private Long newCreateId;

    public EntityOperationDetails(OperationContext operationContext, XmlElement xmlElement) {
        this.operationContext = operationContext;
        this.operationElement = xmlElement;
        this.system = this.operationContext.getDataServiceDeployment().getSystem();
        try {
            this.extractOperationId();
            this.extractSystemRoleContext();
            this.extractOperation();
            this.extractReturnSecurityClauseIds();
            this.extractEntity();
            this.establishDataSources();
            this.establishConstraintSet();
            this.extractWhereFields();
            this.extractUpdateFields();
            this.extractReturnFields();
            this.establishReturnSystemFields();
            this.establishKeyFields();
            this.establishSecurityClauseSets();
        }
        catch (ClientInteractionException clientInteractionException) {
            throw clientInteractionException;
        }
        catch (UnexpectedErrorException unexpectedErrorException) {
            throw unexpectedErrorException;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public String getOperationId() {
        return this.operationId;
    }

    public SystemConfiguration getSystem() {
        return this.system;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public Constants.EntityOperation getOperation() {
        return this.operation;
    }

    public boolean returnSecurityClauseIds() {
        return this.returnSecurityClauseIds;
    }

    public DataSource getSystemDataSource() {
        return this.systemDataSource;
    }

    public Entity.DataSource getEntityDataSource() {
        return this.entityDataSource;
    }

    public Constants.DataSourceEngine getEngine() {
        return this.engine;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public ConstraintSet getConstraintSet() {
        return this.constraintSet;
    }

    public Set<Field> getPrimaryKeyFields() {
        return this.entity.getPrimaryKey().getFields(this.entity);
    }

    public List<Field> getWhereFields() {
        return this.whereFields;
    }

    public List<FieldValue> getWhereFieldValues() {
        return this.whereFieldValues;
    }

    public Set<Field> getUpdateFields() {
        return this.updateFields;
    }

    public List<FieldValue> getUpdateFieldValues() {
        return this.updateFieldValues;
    }

    public FieldValue getUpdateFieldValue(Field field) {
        FieldValue fieldValue = null;
        int n = 0;
        for (Field field2 : this.getUpdateFields()) {
            ++n;
            if (!field2.equals(field)) continue;
            break;
        }
        fieldValue = this.updateFieldValues.get(n);
        return fieldValue;
    }

    public Set<Field> getReturnFields() {
        return this.returnFields;
    }

    public Set<Field> getKeyFields() {
        return this.keyFields;
    }

    public Set<SystemField> getReturnSystemFields() {
        return this.returnSystemFields;
    }

    public ValidationOutcomes getValidationOutcomes() {
        return this.validationOutcomes;
    }

    public SecurityClauseSet getPrimarySecurityClauseSet() {
        return this.primarySecurityClauseSet;
    }

    public SecurityClauseSet getOtherSecurityClauseSet() {
        return this.otherSecurityClauseSet;
    }

    public FieldValue getSubmittedRecordVersion() {
        return this.submittedRecordVersion;
    }

    public void setNewCreateId(Long l) {
        this.newCreateId = l;
    }

    public Long getNewCreateId() {
        return this.newCreateId;
    }

    private void extractOperationId() {
        this.operationId = this.operationElement.getOptionalText("id", String.valueOf(this.operationContext.getOperationIndex()));
    }

    private void extractSystemRoleContext() {
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        String string = null;
        nullFreeCollection = this.operationElement.getOptionalElements("system-role-context/system-role");
        if (nullFreeCollection.size() == 0) {
            this.systemRoles = this.operationContext.getUserSecurityContext().getSystemRoles();
        } else {
            this.systemRoles = new HashSet<SystemRole>(1);
            for (XmlElement xmlElement : nullFreeCollection) {
                string = xmlElement.getText();
                if (!this.system.hasSystemRole(string)) {
                    throw new UnrecognizedSystemRoleException(this, string);
                }
                if (!this.operationContext.getUserSecurityContext().hasSystemRole(string)) {
                    throw new UnauthorizedSystemRoleException(this, string);
                }
                this.systemRoles.add(this.system.getSystemRole(string));
            }
        }
    }

    private void extractOperation() {
        this.operation = Constants.EntityOperation.get(this.operationElement.getText("entity-operation/operation-name"));
        switch (this.operation) {
            case LIST: {
                this.allowableWhereNullDirectives = CollectionUtils.getOrderedSet((Object[])Constants.NullDirective.values());
                break;
            }
            default: {
                this.allowableWhereNullDirectives = new HashSet<Constants.NullDirective>(0);
            }
        }
    }

    private void extractReturnSecurityClauseIds() throws Exception {
        boolean bl = false;
        switch (this.operation) {
            case LIST: 
            case GET: 
            case CREATE: 
            case UPDATE: {
                bl = true;
            }
        }
        if (bl) {
            this.returnSecurityClauseIds = this.operationElement.getOptionalBoolean("entity-operation/return-security-clause-ids");
        }
    }

    private void extractEntity() throws Exception {
        String string = null;
        string = this.operationElement.getText("entity-operation/entity");
        this.entity = this.system.getEntity(string);
        if (this.entity == null) {
            throw new UnrecognizedEntityException(this, string);
        }
        if (!this.entity.supportsOperation(this.operation)) {
            throw new UnsupportedEntityOperationException(this);
        }
    }

    private void establishDataSources() throws Exception {
        if (this.entity.getDataSource() == null) {
            this.systemDataSource = this.system.getDefaultDataSource();
            this.entityDataSource = new Entity.DataSource();
            this.entityDataSource.name = this.systemDataSource.getName();
            this.entityDataSource.schema = this.systemDataSource.getDefaultSchema();
        } else {
            this.entityDataSource = new Entity.DataSource();
            this.entityDataSource.name = this.entity.getDataSource().name;
            this.systemDataSource = this.system.getDataSource(this.entityDataSource.name);
            this.entityDataSource.schema = this.entity.getDataSource().schema == null ? this.systemDataSource.getDefaultSchema() : this.entity.getDataSource().schema;
        }
        this.engine = this.operationContext.getDataServiceDeployment().getDataSourceEngine(this.entityDataSource.name);
    }

    private void establishConstraintSet() throws Exception {
        if (!this.operationContext.hasWorkflowContext()) {
            this.constraintSet = this.entity.getConstraintSet("Base");
        }
    }

    private void extractWhereFields() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        EntityOperationUtils.FieldsAndValues fieldsAndValues = null;
        int n = -1;
        Set set = null;
        SystemField field = null;
        List list = null;
        HashSet<SystemField> hashSet = null;
        switch (this.operation) {
            case LIST: 
            case GET: 
            case UPDATE: 
            case DELETE: {
                bl = true;
            }
        }
        switch (this.operation) {
            case GET: 
            case UPDATE: 
            case DELETE: {
                bl2 = true;
            }
        }
        switch (this.operation) {
            case UPDATE: 
            case DELETE: {
                bl3 = this.entity.hasRecordVersionSystemField();
            }
        }
        if (bl && (nullFreeCollection = this.operationElement.getOptionalElements("entity-operation/where-fields/field")).size() > 0) {
            fieldsAndValues = EntityOperationUtils.getFieldsWithValues(this, nullFreeCollection, this.engine, this.entity, this.allowableWhereNullDirectives, false);
            this.whereFields = fieldsAndValues.fields;
            this.whereFieldValues = fieldsAndValues.values;
            set = CollectionUtils.getOrderedSet(new HashSet(3));
            for (SystemField field2 : fieldsAndValues.systemFields) {
                ++n;
                if (field2.isRecordVersionField()) {
                    if (bl3) {
                        this.submittedRecordVersion = fieldsAndValues.systemFieldValues.get(n);
                    } else {
                        field = field2;
                    }
                } else {
                    field = field2;
                }
                if (field == null) continue;
                set.add(field.getName());
                field = null;
            }
            if (set.size() > 0) {
                throw new SystemFieldWhereFieldException(this, Methods.createNamesStringFromNames(set));
            }
            set = null;
        }
        if (this.whereFields == null) {
            this.whereFields = new ArrayList<Field>(0);
            this.whereFieldValues = new ArrayList<FieldValue>(0);
        }
        if (bl2) {
            list = CollectionUtils.collectionToList(this.whereFields);
            for (Field field2 : this.entity.getPrimaryKey().getFields(this.entity)) {
                list.remove(field2);
            }
            if (list.size() > 0) {
                hashSet = new HashSet<SystemField>(1);
                if (bl3) {
                    hashSet.add(this.entity.getRecordVersionSystemField());
                }
                throw new WhereFieldsException(this, Methods.createNamesString(this.entity.getPrimaryKey().getFields(this.entity), hashSet));
            }
        }
        if (bl3 && this.submittedRecordVersion == null) {
            throw new RecordVersionNotSpecifiedException(this, this.entity.getRecordVersionSystemField().getName());
        }
    }

    private void extractUpdateFields() throws Exception {
        boolean bl = false;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        EntityOperationUtils.FieldsAndValues fieldsAndValues = null;
        Field field = null;
        Set<Field> set = null;
        boolean bl2 = false;
        int n = -1;
        List list = null;
        List list2 = null;
        int n2 = 0;
        switch (this.operation) {
            case CREATE: 
            case UPDATE: {
                bl = true;
            }
        }
        set = this.entity.getPrimaryKey().getFields(this.entity);
        if (bl && (nullFreeCollection = this.operationElement.getOptionalElements("entity-operation/update-fields/field")).size() > 0) {
            fieldsAndValues = EntityOperationUtils.getFieldsWithValues(this, nullFreeCollection, this.engine, this.entity, CollectionUtils.arrayToSet((Object[])new Constants.NullDirective[]{Constants.NullDirective.NULL}), true);
            field = (Field)CollectionUtils.getDuplicate(fieldsAndValues.fields);
            if (field != null) {
                throw new DuplicateUpdateFieldException(this, field.getName());
            }
            this.updateFields = CollectionUtils.collectionToSet(fieldsAndValues.fields);
            this.updateFieldValues = fieldsAndValues.values;
            if (this.operation == Constants.EntityOperation.CREATE) {
                if (this.entity.getPrimaryKey().isCompoundImmutable() || this.entity.getPrimaryKey().isCompoundMutable()) {
                    for (Field field2 : set) {
                        if (this.updateFields.contains(field2)) continue;
                        throw new PrimaryKeyWhereFieldsRequiredException(this, Methods.createNamesStringFromFields(this.entity.getPrimaryKey().getFields(this.entity)));
                    }
                } else {
                    bl2 = true;
                }
            } else if (this.operation == Constants.EntityOperation.UPDATE && !this.entity.getPrimaryKey().isCompoundMutable()) {
                bl2 = true;
            }
            if (fieldsAndValues.systemFields.size() > 0) {
                throw new SystemFieldUpdateException(this, fieldsAndValues.systemFields.get(0).getName());
            }
        }
        if (this.updateFields == null) {
            this.updateFields = new HashSet<Field>(0);
        } else {
            if (bl2) {
                for (Field field2 : this.updateFields) {
                    if (!set.contains(field2)) continue;
                    throw new PrimaryKeyUpdateException(this, field2.getName());
                }
            } else {
                n = -1;
                for (Field field2 : this.updateFields) {
                    if (!set.contains(field2) || !this.updateFieldValues.get(++n).isNull()) continue;
                    throw new PrimaryKeyNullValueException(this, field2.getName());
                }
            }
            if (this.operation == Constants.EntityOperation.CREATE) {
                list = CollectionUtils.collectionToList(this.updateFields);
                list2 = CollectionUtils.collectionToList(this.updateFieldValues);
                this.updateFields = CollectionUtils.getOrderedSet(new HashSet(this.entity.getFields().size()));
                this.updateFieldValues = new ArrayList<FieldValue>(this.updateFields.size());
                for (Field field2 : this.entity.getFields()) {
                    n2 = list.indexOf(field2);
                    if (n2 < 0) {
                        if (!field2.hasDefaultValue()) continue;
                        this.updateFields.add(field2);
                        this.updateFieldValues.add(field2.getDefaultValue().getFieldValue(field2.getDataSourceFieldType(this.engine)));
                        continue;
                    }
                    this.updateFields.add(field2);
                    this.updateFieldValues.add((FieldValue)list2.get(n2));
                }
            }
            this.validationOutcomes = EntityOperationUtils.validate(this, this.updateFields, this.updateFieldValues);
        }
    }

    private void extractReturnFields() throws Exception {
        Set<String> set = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Set<Field> set2 = null;
        switch (this.operation) {
            case LIST: {
                set = this.entity.getListReturnFields();
                break;
            }
            case GET: {
                set = this.entity.getGetReturnFields();
            }
        }
        this.returnFields = CollectionUtils.getOrderedSet(new HashSet(set == null ? 10 : set.size()));
        for (Field object : this.entity.getPrimaryKey().getFields(this.entity)) {
            this.returnFields.add(object);
        }
        if (set != null) {
            nullFreeCollection = this.operationElement.getOptionalElements("entity-operation/return-fields/field");
            if (nullFreeCollection.size() > 0) {
                set2 = EntityOperationUtils.getReturnFields(this, nullFreeCollection, this.entity);
            }
            if (set2 == null) {
                for (String string : set) {
                    this.returnFields.add(this.entity.getField(string));
                }
            } else {
                for (Field field : set2) {
                    if (set.contains(field.getName())) continue;
                    throw new UnsupportedReturnFieldException(this, field.getName());
                }
                for (Field field : set2) {
                    this.returnFields.add(field);
                }
                this.returnFieldsAreExplicit = true;
            }
        }
    }

    private void establishReturnSystemFields() throws Exception {
        for (SystemField systemField : this.entity.getSystemFields()) {
            if (this.operation != Constants.EntityOperation.DELETE && (systemField.isRecordStatusField() || systemField.isRecordVersionField())) {
                this.returnSystemFields.add(systemField);
            }
            if (this.operation == Constants.EntityOperation.CREATE) {
                if (systemField.isCreateUserField()) {
                    this.returnSystemFields.add(systemField);
                }
                if (systemField.isCreateTimestampField()) {
                    this.returnSystemFields.add(systemField);
                }
            }
            if (this.operation != Constants.EntityOperation.CREATE && this.operation != Constants.EntityOperation.UPDATE) continue;
            if (systemField.isUpdateUserField()) {
                this.returnSystemFields.add(systemField);
            }
            if (!systemField.isUpdateTimestampField()) continue;
            this.returnSystemFields.add(systemField);
        }
    }

    private void establishKeyFields() throws Exception {
        boolean bl = false;
        switch (this.operation) {
            case CREATE: 
            case UPDATE: {
                bl = true;
            }
        }
        this.keyFields = CollectionUtils.getOrderedSet(new HashSet(3));
        if (bl) {
            for (Key key : this.entity.getKeys()) {
                for (String string : key.getFields()) {
                    this.keyFields.add(this.entity.getField(string));
                }
            }
        }
    }

    private void establishSecurityClauseSets() {
        this.primarySecurityClauseSet = EntityOperationUtils.getSecurityClauseSet(this, this.systemRoles, this.entity, this.operation, this.whereFields, this.updateFields, this.returnFields, this.returnFieldsAreExplicit);
        switch (this.operation) {
            case LIST: 
            case GET: 
            case CREATE: 
            case UPDATE: {
                this.otherSecurityClauseSet = new SecurityClauseSet();
                this.otherSecurityClauseSet.add(EntityOperationUtils.getSecurityClauseSet(this, this.systemRoles, this.entity, Constants.EntityOperation.GET));
                this.otherSecurityClauseSet.add(EntityOperationUtils.getSecurityClauseSet(this, this.systemRoles, this.entity, Constants.EntityOperation.UPDATE));
                this.otherSecurityClauseSet.add(EntityOperationUtils.getSecurityClauseSet(this, this.systemRoles, this.entity, Constants.EntityOperation.DELETE));
            }
        }
    }
}

