/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.databasemetadata;

import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey {
    private static final Logger logger = Logger.getLogger(ForeignKey.class);
    public static final String CASCADE_UNKNOWN = "Unknown";
    public static final String CASCADE_NO = "NoCascade";
    public static final String CASCADE_YES = "Cascade";
    public static final String CASCADE_NULL = "SetNull";
    public static final String CASCADE_DEFAULT = "SetDefault";
    private String name;
    private String primaryKeyTableName;
    private String foreignKeyTableName;
    private List<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>(1);

    public ForeignKey(String string, String string2, String string3) {
        this.name = string;
        this.primaryKeyTableName = string2;
        this.foreignKeyTableName = string3;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryKeyTableName() {
        return this.primaryKeyTableName;
    }

    public String getForeignKeyTableName() {
        return this.foreignKeyTableName;
    }

    public void addColumnMapping(ColumnMapping columnMapping) {
        this.columnMappings.add(columnMapping);
    }

    public List<ColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    public static String getCascadeValue(int n) {
        String string = null;
        switch (n) {
            case 1: 
            case 3: {
                string = CASCADE_NO;
            }
            case 0: {
                string = CASCADE_YES;
            }
            case 2: {
                string = CASCADE_NULL;
            }
            case 4: {
                string = CASCADE_DEFAULT;
            }
        }
        string = CASCADE_UNKNOWN;
        return string;
    }

    public boolean hasForeignKeyColumn(String string, String string2) {
        boolean bl = false;
        if (this.foreignKeyTableName.equals(string)) {
            for (ColumnMapping columnMapping : this.columnMappings) {
                if (!columnMapping.foreignKeyColumnName.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static class ColumnMapping {
        public String primaryKeyColumnName;
        public String foreignKeyColumnName;
        public String updateCascadeBehaviour;
        public String deleteCascadeBehaviour;
    }
}

