/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel.loader;

import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.loader.SectionLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SectionsLoader {
    private static final Logger logger = Logger.getLogger(SectionsLoader.class);
    private Parent parent;
    private File rootDirectory;
    private XmlElement sectionsElement;
    private List<HeaderFooter> headers;
    private List<HeaderFooter> footers;

    public SectionsLoader(Parent parent, File file, XmlElement xmlElement, List<HeaderFooter> list, List<HeaderFooter> list2) {
        this.parent = parent;
        this.rootDirectory = file;
        this.sectionsElement = xmlElement;
        this.headers = list;
        this.footers = list2;
    }

    public List<Section> execute() {
        ArrayList<Section> arrayList = null;
        Section section = null;
        try {
            arrayList = new ArrayList<Section>(1);
            for (XmlElement xmlElement : this.sectionsElement.getOptionalElements("id")) {
                section = new SectionLoader(this.parent, new File(this.rootDirectory, xmlElement.getText() + ".xml"), this.headers, this.footers).execute();
                arrayList.add(section);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return arrayList;
    }
}

