/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel.loader;

import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.loader.SectionsLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SectionLoader {
    private static final Logger logger = Logger.getLogger(SectionLoader.class);
    private Parent parent;
    private File sectionFile;
    private List<HeaderFooter> headers;
    private List<HeaderFooter> footers;
    private boolean passOnRootDirectory;

    public SectionLoader(Parent parent, File file, List<HeaderFooter> list, List<HeaderFooter> list2) {
        this(parent, file, list, list2, false);
    }

    public SectionLoader(Parent parent, File file, List<HeaderFooter> list, List<HeaderFooter> list2, boolean bl) {
        this.parent = parent;
        this.sectionFile = file;
        this.headers = list;
        this.footers = list2;
        this.passOnRootDirectory = bl;
    }

    public Section execute() {
        Section section = null;
        XmlElement xmlElement = null;
        int n = 0;
        boolean bl = false;
        String string = null;
        Constants.Orientation orientation = null;
        Margins margins = null;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        List<Section> list = null;
        HeaderFooter headerFooter = null;
        HeaderFooter headerFooter2 = null;
        File file = null;
        try {
            section = new Section();
            xmlElement = XmlElementFactory.load(this.sectionFile);
            n = Integer.parseInt(this.sectionFile.getName().substring(0, this.sectionFile.getName().indexOf(".")));
            bl = xmlElement.getAttributeBoolean("isChapter");
            string = xmlElement.getAttributeText("title");
            if (xmlElement.hasAttribute("orientation")) {
                orientation = Constants.Orientation.valueOf(xmlElement.getAttributeText("orientation"));
            }
            if (xmlElement.hasAttribute("margins")) {
                margins = new Margins(xmlElement.getAttributeText("margins"));
            }
            string2 = xmlElement.getOptionalAttributeText("header", null);
            string3 = xmlElement.getOptionalAttributeText("footer", null);
            bl2 = xmlElement.getAttributeBoolean("toc");
            bl3 = xmlElement.getAttributeBoolean("newPage");
            list = new SectionsLoader(section, this.sectionFile.getParentFile(), xmlElement.getElement("sections"), this.headers, this.footers).execute();
            headerFooter = this.getHeaderFooterWithName(this.headers, string2);
            headerFooter2 = this.getHeaderFooterWithName(this.footers, string3);
            if (this.passOnRootDirectory) {
                file = this.sectionFile.getParentFile();
            }
            section.init(file, this.parent, n, bl, string, orientation, margins, headerFooter, headerFooter2, bl2, bl3, list);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return section;
    }

    private HeaderFooter getHeaderFooterWithName(List<HeaderFooter> list, String string) {
        HeaderFooter headerFooter = null;
        for (HeaderFooter headerFooter2 : list) {
            if (!headerFooter2.getName().equals(string)) continue;
            headerFooter = headerFooter2;
            break;
        }
        return headerFooter;
    }
}

