/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel.loader;

import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.Style;
import com.jronimo.documenter.objectmodel.loader.FootersLoader;
import com.jronimo.documenter.objectmodel.loader.HeadersLoader;
import com.jronimo.documenter.objectmodel.loader.SectionsLoader;
import com.jronimo.documenter.objectmodel.loader.StylesLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentLoader {
    private static final Logger logger = Logger.getLogger(DocumentLoader.class);
    private Parent parent;
    private File rootDirectory;

    public DocumentLoader(Parent parent, File file) {
        this.parent = parent;
        this.rootDirectory = file;
    }

    public Document execute() {
        Document document = null;
        File file = null;
        XmlElement xmlElement = null;
        int n = 0;
        String string = null;
        Constants.Orientation orientation = null;
        Margins margins = null;
        String string2 = null;
        String string3 = null;
        List<Style> list = null;
        List<HeaderFooter> list2 = null;
        List<HeaderFooter> list3 = null;
        List<Section> list4 = null;
        HeaderFooter headerFooter = null;
        HeaderFooter headerFooter2 = null;
        try {
            document = new Document();
            file = new File(this.rootDirectory, "Document.xml");
            xmlElement = XmlElementFactory.load(file);
            n = Integer.parseInt(this.rootDirectory.getName());
            string = xmlElement.getAttributeText("title");
            if (xmlElement.hasAttribute("orientation")) {
                orientation = Constants.Orientation.valueOf(xmlElement.getAttributeText("orientation"));
            }
            if (xmlElement.hasAttribute("margins")) {
                margins = new Margins(xmlElement.getAttributeText("margins"));
            }
            string2 = xmlElement.getOptionalAttributeText("header", null);
            string3 = xmlElement.getOptionalAttributeText("footer", null);
            list = new StylesLoader(document, new File(this.rootDirectory, "Styles")).execute();
            list2 = new HeadersLoader(document, new File(this.rootDirectory, "Headers")).execute();
            list3 = new FootersLoader(document, new File(this.rootDirectory, "Footers")).execute();
            list4 = new SectionsLoader(document, new File(this.rootDirectory, "Sections"), xmlElement.getElement("chapters"), list2, list3).execute();
            headerFooter = this.getHeaderFooterWithName(list2, string2);
            headerFooter2 = this.getHeaderFooterWithName(list3, string3);
            document.init(this.parent, n, string, orientation, margins, headerFooter, headerFooter2, list, list2, list3, list4);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return document;
    }

    private HeaderFooter getHeaderFooterWithName(List<HeaderFooter> list, String string) {
        HeaderFooter headerFooter = null;
        for (HeaderFooter headerFooter2 : list) {
            if (!headerFooter2.getName().equals(string)) continue;
            headerFooter = headerFooter2;
            break;
        }
        return headerFooter;
    }
}

