/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel;

import com.jronimo.documenter.ResourceTextIdentifiers;
import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.Style;
import com.jronimo.documenter.objectmodel.loader.DocumentLoader;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Project
implements Parent,
Comparable<Project> {
    private static final Logger logger = Logger.getLogger(Project.class);
    private Parent parent;
    private String name;
    private String id;
    private int nextId;
    private Constants.Orientation orientation;
    private Margins margins;
    private HeaderFooter header;
    private HeaderFooter footer;
    private List<Style> styles;
    private List<HeaderFooter> headers;
    private List<HeaderFooter> footers;
    private List<Document> documents;

    public void init(Parent parent, String string, String string2, int n, Constants.Orientation orientation, Margins margins, HeaderFooter headerFooter, HeaderFooter headerFooter2, List<Style> list, List<HeaderFooter> list2, List<HeaderFooter> list3, List<Document> list4) {
        this.parent = parent;
        this.name = string;
        this.id = string2;
        this.nextId = n;
        this.orientation = orientation;
        this.margins = margins;
        this.header = headerFooter;
        this.footer = headerFooter2;
        this.styles = list;
        this.headers = list2;
        this.footers = list3;
        this.documents = list4;
    }

    private File getFile() {
        return new File(this.getRootDirectory(), "DocumentationProject.xml");
    }

    public String getId() {
        return this.id;
    }

    public int getNextId() {
        int n = 0;
        n = this.nextId++;
        this.saveFile(false);
        return n;
    }

    public String getName() {
        return this.getRootDirectory().getName();
    }

    public void setOrientation(Constants.Orientation orientation) {
        this.orientation = orientation;
        this.saveFile(true);
    }

    @Override
    public Constants.Orientation getOrientation() {
        return this.orientation;
    }

    public void setMargins(Margins margins) {
        this.margins = margins;
        this.saveFile(true);
    }

    @Override
    public Margins getMargins() {
        return this.margins;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getHeader() {
        return this.header;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getFooter() {
        return this.footer;
    }

    public List<Style> getStyles() {
        return this.styles;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
        Collections.sort(this.styles);
    }

    public void removeStyle(Style style) {
        this.styles.remove(style);
        style.delete();
    }

    public boolean hasStyleWithName(String string) {
        boolean bl = false;
        for (Style style : this.styles) {
            if (!style.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<HeaderFooter> getHeaders() {
        return this.headers;
    }

    public void addHeader(HeaderFooter headerFooter) {
        this.headers.add(headerFooter);
        Collections.sort(this.headers);
    }

    public void removeHeader(HeaderFooter headerFooter) {
        this.headers.remove(headerFooter);
        headerFooter.delete();
    }

    public boolean hasHeaderWithName(String string) {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.headers) {
            if (!headerFooter.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<HeaderFooter> getFooters() {
        return this.footers;
    }

    public void addFooter(HeaderFooter headerFooter) {
        this.footers.add(headerFooter);
        Collections.sort(this.footers);
    }

    public void removeFooter(HeaderFooter headerFooter) {
        this.footers.remove(headerFooter);
        headerFooter.delete();
    }

    public boolean hasFooterWithName(String string) {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.footers) {
            if (!headerFooter.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public List<String> getDocumentNames() {
        ArrayList<String> arrayList = null;
        arrayList = new ArrayList<String>(this.documents.size());
        for (Document document : this.documents) {
            arrayList.add(document.getTitle());
        }
        return arrayList;
    }

    public void addDocument(File file, int n) {
        this.addDocument(new DocumentLoader(this, file).execute(), n);
    }

    private void addDocument(Document document, int n) {
        Assert.errorParam(this.hasDocument(document.getTitle()), new ResourceTextPointer((Object)ResourceTextIdentifiers.PROJECT_WITH_NAME_EXISTS, document.getTitle()));
        this.documents.add(n, document);
        this.saveFile(true);
    }

    public void deleteDocuments(Collection<String> collection, boolean bl) {
        for (String string : collection) {
            this.deleteDocument(this.getDocument(string), false);
        }
        this.saveFile(bl);
    }

    public void deleteDocument(Document document, boolean bl) {
        this.documents.remove(document);
        document.delete();
        this.saveFile(bl);
    }

    public boolean hasDocument(String string) {
        boolean bl = false;
        for (Document document : this.documents) {
            if (!document.getTitle().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Document getDocument(String string) {
        Document document = null;
        for (Document document2 : this.documents) {
            if (!document2.getTitle().equals(string)) continue;
            document = document2;
            break;
        }
        return document;
    }

    public void changeDocumentOrder(List<Document> list) {
        ArrayList<Document> arrayList = null;
        arrayList = new ArrayList<Document>(this.documents.size());
        for (Document document : list) {
            if (!this.documents.contains(document)) continue;
            arrayList.add(document);
        }
        this.documents.clear();
        for (Document document : arrayList) {
            this.documents.add(document);
        }
        this.saveFile(true);
    }

    private File getDeletionBinDirectory() {
        File file = null;
        file = new File(this.getRootDirectory(), "deleted");
        return file;
    }

    @Override
    public int compareTo(Project project) {
        return this.getName().compareTo(project.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void saveFile(boolean bl) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("documentation-project");
        xmlElement.setAttributeText("id", this.id);
        xmlElement.setAttributeInteger("nextId", this.nextId);
        if (this.orientation != null) {
            xmlElement.setAttributeText("orientation", this.orientation.toString());
        }
        if (this.margins != null) {
            xmlElement.setAttributeText("margins", this.margins.toString());
        }
        if (this.header != null) {
            xmlElement.setAttributeText("header", this.header.getName());
        }
        if (this.footer != null) {
            xmlElement.setAttributeText("footer", this.footer.getName());
        }
        xmlElement2 = xmlElement.addElement("documents");
        for (Document document : this.documents) {
            xmlElement2.addElement("id").setInteger(document.getId());
        }
        xmlElement.save(this.getFile());
        if (bl) {
            this.getDocumenter().fireProjectUpdated(this);
        }
    }

    public void deleteFromSource() {
        try {
            FileMethods.deleteFolderContents(this.getRootDirectory(), true);
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public File getRootDirectory() {
        return new File(this.parent.getRootDirectory(), this.name);
    }

    @Override
    public Documenter getDocumenter() {
        return this.parent.getDocumenter();
    }

    @Override
    public Source getSource() {
        return this.parent.getSource();
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public Document getDocument() {
        return null;
    }
}

