/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel;

import com.jronimo.documenter.ResourceTextIdentifiers;
import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.DateUtils;
import com.jronimo.util.EventFirer;
import com.jronimo.util.MethodInvoker;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Documenter
implements Parent {
    private static Documenter instance;
    private File file;
    private List<Source> sources;
    private Collection<Listener> listeners = new ArrayList<Listener>(1);

    private Documenter(File file, List<Source> list) {
        this.file = file;
        this.sources = list;
    }

    public static synchronized Documenter createInstance(File file, List<Source> list) {
        if (instance == null) {
            instance = new Documenter(file, list);
        }
        return instance;
    }

    public static Documenter getInstance() {
        return instance;
    }

    public static String generateRandomId() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        stringBuilder.append(DateUtils.getUniqueDateTimeTemporalValue());
        stringBuilder.append("-");
        stringBuilder.append(Methods.getRandomNumber(1000000L, 9999999L));
        return stringBuilder.toString();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void addSource(Source.SourceType sourceType, String string, File file) {
        Source source = null;
        Assert.errorParam(this.hasSource(string), new ResourceTextPointer((Object)ResourceTextIdentifiers.SOURCE_WITH_NAME_EXISTS, string));
        Assert.errorParam(this.hasSource(file), new ResourceTextPointer((Object)ResourceTextIdentifiers.SOURCE_WITH_DIRECTORY_EXISTS, file.getPath()));
        source = new Source();
        source.init(this, Documenter.generateRandomId(), sourceType, string, file, null);
        this.sources.add(source);
        Collections.sort(this.sources);
        this.saveFile(true);
    }

    public void removeSource(Source source) {
        this.sources.remove(source);
        this.saveFile(true);
    }

    public boolean hasSource(String string) {
        boolean bl = false;
        for (Source source : this.sources) {
            if (!source.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasSource(File file) {
        boolean bl = false;
        for (Source source : this.sources) {
            if (!source.getRootDirectory().equals(file)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Source getSource(File file) {
        Source source = null;
        for (Source source2 : this.sources) {
            if (!source2.getRootDirectory().equals(file)) continue;
            source = source2;
            break;
        }
        return source;
    }

    private void saveFile(boolean bl) {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("documentation-sources");
        for (Source source : this.sources) {
            source.appendXmlElement(xmlElement);
        }
        xmlElement.save(this.file);
        if (bl) {
            this.fireSourcesUpdated();
        }
    }

    @Override
    public Parent getParent() {
        return null;
    }

    @Override
    public File getRootDirectory() {
        return null;
    }

    @Override
    public Documenter getDocumenter() {
        return this;
    }

    @Override
    public Source getSource() {
        return null;
    }

    @Override
    public Project getProject() {
        return null;
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public Constants.Orientation getOrientation() {
        return null;
    }

    @Override
    public Margins getMargins() {
        return null;
    }

    @Override
    public HeaderFooter getHeader() {
        return null;
    }

    @Override
    public HeaderFooter getFooter() {
        return null;
    }

    public void fireSourcesUpdated() {
        ListenerAdapter.fireEvent(this.listeners, "sourcesUpdated", new Event(null));
    }

    public void fireSourceUpdated(Source source) {
        this.saveFile(false);
        ListenerAdapter.fireEvent(this.listeners, "sourceUpdated", new Event(source));
    }

    public void fireProjectUpdated(Project project) {
        ListenerAdapter.fireEvent(this.listeners, "projectUpdated", new Event(project));
    }

    public void fireDocumentUpdated(Document document) {
        ListenerAdapter.fireEvent(this.listeners, "documentUpdated", new Event(document));
    }

    public void fireSectionUpdated(Section section) {
        ListenerAdapter.fireEvent(this.listeners, "sectionUpdated", new Event(section));
    }

    public static class ListenerAdapter
    implements Listener {
        private static void fireEvent(Collection collection, String string, Event event) {
            new EventFirer(collection, ListenerAdapter.getMethodInvoker(string, event)).execute(true);
        }

        private static MethodInvoker getMethodInvoker(String string, Event event) {
            return new MethodInvoker(Listener.class, null, string, null, new Object[]{event});
        }

        public void sourcesUpdated(Event event) {
        }

        public void sourceUpdated(Event event) {
        }

        public void projectUpdated(Event event) {
        }

        public void documentUpdated(Event event) {
        }

        public void sectionUpdated(Event event) {
        }
    }

    public static interface Listener {
        public void sourcesUpdated(Event var1);

        public void sourceUpdated(Event var1);

        public void projectUpdated(Event var1);

        public void documentUpdated(Event var1);

        public void sectionUpdated(Event var1);
    }

    public class Event {
        private Documenter documenter;
        private Object subject;

        private Event(Object object) {
            this.documenter = Documenter.this;
            this.subject = object;
        }

        public Documenter getDocumenter() {
            return this.documenter;
        }

        public Object getSubject() {
            return this.subject;
        }

        public Source getSource() {
            return (Source)this.subject;
        }

        public Project getProject() {
            return (Project)this.subject;
        }

        public Document getDocument() {
            return (Document)this.subject;
        }

        public Section getChapter() {
            return (Section)this.subject;
        }

        public Section getSection() {
            return (Section)this.subject;
        }
    }
}

