/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel;

import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.Style;
import com.jronimo.documenter.objectmodel.loader.SectionLoader;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Document
implements Parent {
    private static final Logger logger = Logger.getLogger(Document.class);
    private Parent parent;
    private int id;
    private String title;
    private Constants.Orientation orientation;
    private Margins margins;
    private HeaderFooter header;
    private HeaderFooter footer;
    private List<Section> chapters;
    private List<Style> styles;
    private List<HeaderFooter> headers;
    private List<HeaderFooter> footers;

    public void init(Parent parent, int n, String string, Constants.Orientation orientation, Margins margins, HeaderFooter headerFooter, HeaderFooter headerFooter2, List<Style> list, List<HeaderFooter> list2, List<HeaderFooter> list3, List<Section> list4) {
        this.parent = parent;
        this.id = n;
        this.title = string;
        this.orientation = orientation;
        this.margins = margins;
        this.header = headerFooter;
        this.footer = headerFooter2;
        this.chapters = list4;
        this.styles = list;
        this.headers = list2;
        this.footers = list3;
    }

    private File getFile() {
        return new File(this.getRootDirectory(), "Document.xml");
    }

    public void setId(int n) {
        if (this.id != n) {
            FileMethods.moveDirectory(this.getRootDirectory(), new File(this.getRootDirectory().getParentFile(), String.valueOf(n)));
            this.id = n;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setTitle(String string) {
        this.title = string;
        this.saveFile(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setOrientation(Constants.Orientation orientation) {
        this.orientation = orientation;
        this.saveFile(true);
    }

    @Override
    public Constants.Orientation getOrientation() {
        Constants.Orientation orientation = null;
        orientation = this.orientation == null ? this.parent.getOrientation() : this.orientation;
        return orientation;
    }

    public void setMargins(Margins margins) {
        this.margins = margins;
        this.saveFile(true);
    }

    @Override
    public Margins getMargins() {
        Margins margins = null;
        margins = this.margins == null ? this.parent.getMargins() : this.margins;
        return margins;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getHeader() {
        HeaderFooter headerFooter = null;
        headerFooter = this.header == null ? this.parent.getHeader() : this.header;
        return headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getFooter() {
        HeaderFooter headerFooter = null;
        headerFooter = this.footer == null ? this.parent.getFooter() : this.footer;
        return headerFooter;
    }

    public List<Style> getStyles() {
        return this.styles;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
        Collections.sort(this.styles);
    }

    public void removeStyle(Style style) {
        this.styles.remove(style);
        style.delete();
    }

    public boolean hasStyleWithName(String string) {
        boolean bl = false;
        for (Style style : this.styles) {
            if (!style.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<HeaderFooter> getHeaders() {
        return this.headers;
    }

    public void addHeader(HeaderFooter headerFooter) {
        this.headers.add(headerFooter);
        Collections.sort(this.headers);
    }

    public void removeHeader(HeaderFooter headerFooter) {
        this.headers.remove(headerFooter);
        headerFooter.delete();
    }

    public boolean hasHeaderWithName(String string) {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.headers) {
            if (!headerFooter.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<HeaderFooter> getFooters() {
        return this.footers;
    }

    public void addFooter(HeaderFooter headerFooter) {
        this.footers.add(headerFooter);
        Collections.sort(this.footers);
    }

    public void removeFooter(HeaderFooter headerFooter) {
        this.footers.remove(headerFooter);
        headerFooter.delete();
    }

    public boolean hasFooterWithName(String string) {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.footers) {
            if (!headerFooter.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<Section> getChapters() {
        return this.chapters;
    }

    public List<String> getChapterTitles() {
        ArrayList<String> arrayList = null;
        arrayList = new ArrayList<String>(this.chapters.size());
        for (Section section : this.chapters) {
            arrayList.add(section.getTitle());
        }
        return arrayList;
    }

    public void addChapter(File file, int n) {
        String string = null;
        int n2 = 0;
        string = file.getName();
        string = string.substring(0, string.lastIndexOf("."));
        n2 = Integer.parseInt(string);
        this.addChapter(new SectionLoader(this, file, this.headers, this.footers).execute(), n);
    }

    private void addChapter(Section section, int n) {
        this.chapters.add(n, section);
        this.saveFile(true);
    }

    public void deleteChapters(Collection<String> collection) {
        for (String string : collection) {
            this.deleteChapter(this.getChapter(string), false);
        }
        this.saveFile(true);
    }

    public void deleteChapter(Section section) {
        this.deleteChapter(section, true);
    }

    private void deleteChapter(Section section, boolean bl) {
        this.chapters.remove(section);
        section.delete();
        if (bl) {
            this.saveFile(true);
        }
    }

    public boolean hasChapter(String string) {
        boolean bl = false;
        for (Section section : this.chapters) {
            if (!section.getTitle().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Section getChapter(String string) {
        Section section = null;
        for (Section section2 : this.chapters) {
            if (!section2.getTitle().equals(string)) continue;
            section = section2;
            break;
        }
        return section;
    }

    public void changeChapterOrder(List<Section> list) {
        ArrayList<Section> arrayList = null;
        boolean bl = false;
        arrayList = new ArrayList<Section>(this.chapters.size());
        for (Section section : list) {
            if (!this.chapters.contains(section)) continue;
            arrayList.add(section);
        }
        this.chapters.clear();
        for (Section section : arrayList) {
            this.chapters.add(section);
        }
        this.saveFile(true);
    }

    File getDeletionBinDirectory() {
        File file = null;
        file = new File(this.getRootDirectory(), "deleted");
        return file;
    }

    public int hashCode() {
        return this.title.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return this.title;
    }

    public void saveFile(boolean bl) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("document");
        xmlElement.setAttributeText("title", this.title);
        if (this.orientation != null) {
            xmlElement.setAttributeText("orientation", this.orientation.toString());
        }
        if (this.margins != null) {
            xmlElement.setAttributeText("margins", this.margins.toString());
        }
        if (this.header != null) {
            xmlElement.setAttributeText("header", this.header.getName());
        }
        if (this.footer != null) {
            xmlElement.setAttributeText("footer", this.footer.getName());
        }
        xmlElement2 = xmlElement.addElement("chapters");
        for (Section section : this.chapters) {
            xmlElement2.addElement("id").setInteger(section.getId());
        }
        xmlElement.save(this.getFile());
        if (bl) {
            this.parent.getDocumenter().fireDocumentUpdated(this);
        }
    }

    public void delete() {
        File file = null;
        file = new File(this.getDeletionBinDirectory(), "DeletedDocuments/" + this.id);
        FileMethods.moveDirectory(this.getRootDirectory(), file);
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public File getRootDirectory() {
        return new File(this.parent.getRootDirectory(), "Documents/" + this.id);
    }

    @Override
    public Documenter getDocumenter() {
        return this.parent.getDocumenter();
    }

    @Override
    public Source getSource() {
        return this.parent.getSource();
    }

    @Override
    public Project getProject() {
        return this.parent.getProject();
    }

    @Override
    public Document getDocument() {
        return this;
    }
}

