/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.popups;

import com.jronimo.documenter.gui.ComponentFactory;
import com.jronimo.swing.DisplayOptions;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public final class DragAndDropPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(DragAndDropPopup.class);
    private JLabel sourceLabel;
    private JLabel sourceValueLabel;
    private JLabel targetLabel;
    private JLabel targetValueLabel;
    private JSeparator separator;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel actionLabel;
    private JRadioButton insertBeforeRadioButton;
    private JRadioButton insertAfterRadioButton;
    private JRadioButton addAsChildRadioButton;
    private JRadioButton mergeRadioButton;
    private JCheckBox deleteSourceCheckBox;
    private JCheckBox goToCheckBox;
    private ButtonPanel buttonPanel;
    private ResultStruct result;
    private int optionCount;

    public DragAndDropPopup(JFrame jFrame, ConfigStruct configStruct) {
        super(jFrame, "Drag-N-Drop", true);
        this.init(jFrame, configStruct);
    }

    public DragAndDropPopup(JDialog jDialog, ConfigStruct configStruct) {
        super(jDialog, "Drag-N-Drop", true);
        this.init(jDialog, configStruct);
    }

    private void init(Container container, ConfigStruct configStruct) {
        this.initializeEventHandlers();
        this.initializeComponents(configStruct);
        this.initializeContainers(container, configStruct);
    }

    private void initializeEventHandlers() {
    }

    private void initializeComponents(ConfigStruct configStruct) {
        ButtonGroup buttonGroup = null;
        this.sourceLabel = ComponentFactory.getLabel("Source:");
        this.sourceValueLabel = ComponentFactory.getLabel(configStruct.sourceValue);
        this.targetLabel = ComponentFactory.getLabel("Target:");
        this.targetValueLabel = ComponentFactory.getLabel(configStruct.targetValue);
        this.separator = new JSeparator();
        this.nameLabel = ComponentFactory.getLabel(configStruct.nameLabelText + ":");
        this.nameTextField = ComponentFactory.getTextField(configStruct.nameValue, true);
        this.nameTextField.setPreferredSize(new Dimension(200, this.nameTextField.getPreferredSize().height));
        this.nameTextField.selectAll();
        this.actionLabel = ComponentFactory.getLabel("Action:");
        buttonGroup = new ButtonGroup();
        if (configStruct.insertBeforeDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            ++this.optionCount;
            this.insertBeforeRadioButton = ComponentFactory.getRadioButton("Insert before", null, configStruct.insertBeforeDisplayChoice);
            buttonGroup.add(this.insertBeforeRadioButton);
        }
        if (configStruct.insertAfterDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            ++this.optionCount;
            this.insertAfterRadioButton = ComponentFactory.getRadioButton("Insert after", null, configStruct.insertAfterDisplayChoice);
            buttonGroup.add(this.insertAfterRadioButton);
        }
        if (configStruct.addAsChildDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            ++this.optionCount;
            this.addAsChildRadioButton = ComponentFactory.getRadioButton("Add as child", null, configStruct.addAsChildDisplayChoice);
            buttonGroup.add(this.addAsChildRadioButton);
        }
        if (configStruct.mergeDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            ++this.optionCount;
            this.mergeRadioButton = ComponentFactory.getRadioButton("Merge with", null, configStruct.mergeDisplayChoice);
            buttonGroup.add(this.mergeRadioButton);
        }
        if (configStruct.deleteSourceDisplayOption != DisplayOptions.CheckBoxDisplayOptions.HIDE) {
            this.deleteSourceCheckBox = ComponentFactory.getCheckBox("Delete source", null, configStruct.deleteSourceDisplayOption);
        }
        if (configStruct.goToDisplayOption != DisplayOptions.CheckBoxDisplayOptions.HIDE) {
            this.goToCheckBox = ComponentFactory.getCheckBox("Go to", null, configStruct.goToDisplayOption);
        }
        this.buttonPanel = new ButtonPanel();
    }

    private void initializeContainers(Container container, ConfigStruct configStruct) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        int n = -1;
        int n2 = 10;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.sourceLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.sourceValueLabel;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.targetLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.targetValueLabel;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.separator;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10001.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.nameLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.nameTextField;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.actionLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = this.optionCount;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        if (configStruct.insertBeforeDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            jComponent = this.insertBeforeRadioButton;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10000.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
        if (configStruct.insertAfterDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            jComponent = this.insertAfterRadioButton;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10000.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
        if (configStruct.addAsChildDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            jComponent = this.addAsChildRadioButton;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10000.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
        if (configStruct.mergeDisplayChoice != DisplayOptions.RadioButtonDisplayOptions.HIDE) {
            jComponent = this.mergeRadioButton;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10000.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
        if (configStruct.deleteSourceDisplayOption != DisplayOptions.CheckBoxDisplayOptions.HIDE) {
            jComponent = this.deleteSourceCheckBox;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10001.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(n2, 10, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
            n2 = 0;
        }
        if (configStruct.goToDisplayOption != DisplayOptions.CheckBoxDisplayOptions.HIDE) {
            jComponent = this.goToCheckBox;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10001.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(n2, 10, 0, 10);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10001.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        this.pack();
        if (container != null) {
            GuiMethods.centerPopup(container, this);
        }
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    private void okButton() {
        this.hide();
        if (this.nameTextField.getText().trim().length() > 0) {
            this.result = new ResultStruct();
            this.result.name = this.nameTextField.getText().trim();
            if (this.insertBeforeRadioButton != null && this.insertBeforeRadioButton.isSelected()) {
                this.result.action = Action.INSERT_BEFORE;
            } else if (this.insertAfterRadioButton != null && this.insertAfterRadioButton.isSelected()) {
                this.result.action = Action.INSERT_AFTER;
            } else if (this.addAsChildRadioButton != null && this.addAsChildRadioButton.isSelected()) {
                this.result.action = Action.ADD_AS_CHILD;
            } else if (this.mergeRadioButton != null && this.mergeRadioButton.isSelected()) {
                this.result.action = Action.MERGE;
            }
            if (this.deleteSourceCheckBox != null && this.deleteSourceCheckBox.isSelected()) {
                this.result.deleteSource = true;
            }
            if (this.goToCheckBox != null && this.goToCheckBox.isSelected()) {
                this.result.goTo = true;
            }
        }
    }

    private void cancelButton() {
        this.hide();
    }

    public Object getResult(boolean bl) {
        ResultStruct resultStruct = null;
        resultStruct = this.result;
        if (bl) {
            this.discard();
        }
        return resultStruct;
    }

    public void discard() {
        this.dispose();
    }

    public class ResultStruct {
        public String name;
        public Action action;
        public boolean deleteSource;
        public boolean goTo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        INSERT_BEFORE,
        INSERT_AFTER,
        ADD_AS_CHILD,
        MERGE;

    }

    public static class ConfigStruct {
        public String sourceValue = "";
        public String targetValue = "";
        public String nameLabelText = "";
        public String nameValue = "";
        public DisplayOptions.RadioButtonDisplayOptions insertBeforeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
        public DisplayOptions.RadioButtonDisplayOptions insertAfterDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
        public DisplayOptions.RadioButtonDisplayOptions addAsChildDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
        public DisplayOptions.RadioButtonDisplayOptions mergeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
        public DisplayOptions.CheckBoxDisplayOptions deleteSourceDisplayOption = DisplayOptions.CheckBoxDisplayOptions.SHOW_UNCHECKED;
        public DisplayOptions.CheckBoxDisplayOptions goToDisplayOption = DisplayOptions.CheckBoxDisplayOptions.SHOW_UNCHECKED;
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel() {
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            DragAndDropPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        DragAndDropPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        DragAndDropPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }
}

