/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.popups;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ComponentFactory;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class CreateProjectPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(CreateProjectPopup.class);
    private ActionListener directoryBrowserButtonListener;
    private JLabel nameLabel;
    private JLabel directoryLabel;
    private JTextField nameTextField;
    private JTextField directoryTextField;
    private JButton directoryBrowserButton;
    private ButtonPanel buttonPanel;
    private Object result;

    public CreateProjectPopup(JFrame jFrame, String string, File file) {
        super(jFrame, string, true);
        this.init(jFrame, file);
    }

    public CreateProjectPopup(JDialog jDialog, String string, File file) {
        super(jDialog, string, true);
        this.init(jDialog, file);
    }

    private void init(Container container, File file) {
        this.initializeEventHandlers();
        this.initializeComponents(file);
        this.initializeContainers(container);
    }

    private void initializeEventHandlers() {
        this.directoryBrowserButtonListener = new DirectoryBrowserButtonListener();
    }

    private void initializeComponents(File file) {
        this.nameLabel = ComponentFactory.getLabel("Project Name:");
        this.nameTextField = ComponentFactory.getTextField("", true);
        this.nameTextField.setPreferredSize(new Dimension(200, this.nameTextField.getPreferredSize().height));
        this.directoryLabel = ComponentFactory.getLabel("Project Directory:");
        this.directoryTextField = ComponentFactory.getTextField("", true);
        this.directoryTextField.setEditable(false);
        this.directoryTextField.setPreferredSize(new Dimension(200, this.nameTextField.getPreferredSize().height));
        this.directoryBrowserButton = ComponentFactory.getButton("...", this.directoryBrowserButtonListener, true);
        this.buttonPanel = new ButtonPanel();
    }

    private void initializeContainers(Container container) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.nameLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.nameTextField;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.directoryLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.directoryTextField;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.directoryBrowserButton;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10001.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        this.pack();
        if (container != null) {
            GuiMethods.centerPopup(container, this);
        }
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    public void showDirectoryBrowser() {
        File file = null;
        if (!(this.directoryTextField.getText().length() <= 0 || (file = new File(this.directoryTextField.getText())).exists() && file.isDirectory())) {
            file = null;
        }
        if (file == null) {
            file = ApplicationManager.getInstance().getDefaultDocumentsFolder();
        }
        if ((file = PopupFactory.showPopupDirectoryBrowser(Frame.getInstance(), "Project Directory", true, file, true)) != null) {
            this.directoryTextField.setText(file.getPath());
            this.directoryTextField.setCaretPosition(0);
        }
    }

    private void okButton() {
        this.hide();
        if (this.nameTextField.getText().trim().length() > 0 && this.directoryTextField.getText().length() > 0) {
            this.result = new ResultStruct();
            ((ResultStruct)this.result).name = this.nameTextField.getText();
            ((ResultStruct)this.result).directory = new File(this.directoryTextField.getText());
        }
    }

    private void cancelButton() {
        this.hide();
    }

    public Object getResult(boolean bl) {
        Object object = null;
        object = this.result;
        if (bl) {
            this.discard();
        }
        return object;
    }

    public void discard() {
        this.dispose();
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel() {
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            CreateProjectPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        CreateProjectPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        CreateProjectPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }

    public class DirectoryBrowserButtonListener
    implements ActionListener {
        private DirectoryBrowserButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = null;
            thread = new Thread(new Runnable(){

                public void run() {
                    CreateProjectPopup.this.showDirectoryBrowser();
                }
            });
            GuiMethods.startEventThread(thread);
        }
    }

    public class ResultStruct {
        public String name;
        public File directory;
    }
}

