/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.FileMethods;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.loader.ProjectLoader;
import com.jronimo.documenter.objectmodel.loader.SectionLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class Methods
extends com.jronimo.documenter.gui.Methods {
    private static final Logger logger = Logger.getLogger(Methods.class);

    protected Methods() {
    }

    public static String getNewProjectNameFromUser(Source source, String string) {
        String string2 = null;
        File file = null;
        Assert.errorParam(source == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "source"));
        string = string == null ? "" : string;
        string2 = PopupFactory.showUserInputPopup(Frame.getInstance(), "New Project", true, "Project Name", string);
        String string3 = string2 = Methods.isEmptyString(string2) ? null : string2;
        if (string2 != null && (file = new File(source.getRootDirectory(), string2)).exists()) {
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Project Already Exists", "The Project cannot be created because a Project with the name \"" + string2 + "\" already exists.");
            string2 = null;
        }
        return string2;
    }

    public static String cloneProject(Project project, Source source, boolean bl) {
        String string = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        XmlElement xmlElement = null;
        Project project2 = null;
        string = Methods.getNewProjectNameFromUser(source, project.getName());
        if (string != null) {
            file = new File(project.getSource().getRootDirectory(), project.getName());
            file2 = new File(source.getRootDirectory(), string);
            FileMethods.copyDirectoryContentsTo(file, file2);
            file3 = new File(file2, "DocumentationProject.xml");
            xmlElement = XmlElementFactory.load(file3);
            xmlElement.setAttributeText("id", Documenter.generateRandomId());
            xmlElement.save(file3);
            project2 = new ProjectLoader(source, string).execute();
            source.loadProject(string, bl);
        }
        return string;
    }

    public static String moveProject(Project project, Source source, boolean bl) {
        String string = null;
        File file = null;
        File file2 = null;
        boolean bl2 = false;
        string = Methods.getNewProjectNameFromUser(source, project.getName());
        if (string != null) {
            file = new File(project.getSource().getRootDirectory(), project.getName());
            file2 = new File(source.getRootDirectory(), string);
            FileMethods.moveDirectory(file, file2);
            bl2 = bl && !source.equals(project.getSource());
            project.getSource().unloadProject(project.getName(), bl2);
            source.loadProject(string, bl);
        }
        return string;
    }

    public static void createDocument(Project project, int n) {
        String string = null;
        boolean bl = true;
        File file = null;
        File file2 = null;
        String string2 = null;
        string = PopupFactory.showUserInputPopup(Frame.getInstance(), "New Document", true, "Document Title", "");
        if (string == null) {
            bl = false;
        } else if (project.hasDocument(string)) {
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Document Title Already Exists", "A document with the title \"" + string + "\" already exists.");
            bl = false;
        }
        if (bl) {
            try {
                file = new File(project.getRootDirectory(), "Documents/" + project.getNextId());
                FileMethods.copyDirectoryContentsTo(new File(ApplicationManager.getInstance().getApplicationFolder(), "templates/Document"), file);
                file2 = new File(file, "Document.xml");
                string2 = FileMethods.readTextFile(file2);
                string2 = string2.replace("New Document", string);
                FileMethods.writeTextFile(file2, string2);
                project.addDocument(file, n);
                ApplicationManager.getInstance().setStatusMessage("Document successfully created: " + string);
            }
            catch (Exception exception) {
                throw new UnexpectedErrorException(exception);
            }
        }
    }

    public static void createChapter(Document document, int n) {
        String string = null;
        boolean bl = true;
        File file = null;
        String string2 = null;
        string = PopupFactory.showUserInputPopup(Frame.getInstance(), "New Chapter", true, "Chapter Title", "");
        if (string == null) {
            bl = false;
        } else if (document.hasChapter(string)) {
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Chapter Title Already Exists", "A chapter with the title \"" + string + "\" already exists.");
            bl = false;
        }
        if (bl) {
            try {
                file = new File(document.getRootDirectory(), "Sections/" + document.getProject().getNextId() + ".xml");
                FileMethods.copyFileTo(new File(ApplicationManager.getInstance().getApplicationFolder(), "templates/Chapter.xml"), file);
                string2 = FileMethods.readTextFile(file);
                string2 = string2.replace("New Chapter", string);
                FileMethods.writeTextFile(file, string2);
                document.addChapter(file, n);
            }
            catch (Exception exception) {
                throw new UnexpectedErrorException(exception);
            }
        }
    }

    public static void createSection(Section section, int n) {
        String string = null;
        boolean bl = true;
        File file = null;
        String string2 = null;
        string = PopupFactory.showUserInputPopup(Frame.getInstance(), "New Section", true, "Section Title", "");
        if (string == null) {
            bl = false;
        } else if (section.hasSection(string)) {
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Section Title Already Exists", "A section with the title \"" + string + "\" already exists.");
            bl = false;
        }
        if (bl) {
            try {
                file = new File(section.getRootDirectory(), section.getProject().getNextId() + ".xml");
                FileMethods.copyFileTo(new File(ApplicationManager.getInstance().getApplicationFolder(), "templates/Section.xml"), file);
                string2 = FileMethods.readTextFile(file);
                string2 = string2.replace("New Section", string);
                FileMethods.writeTextFile(file, string2);
                section.addSection(file, n);
                ApplicationManager.getInstance().setStatusMessage("Section successfully created: " + string);
            }
            catch (Exception exception) {
                throw new UnexpectedErrorException(exception);
            }
        }
    }

    public static void moveSection(Section section, Object object, String string, int n) {
        Assert.errorParam(section == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "section"));
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "newParent"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "newTitle"));
        if (object instanceof Document) {
            Methods.cloneSection(section, (Document)object, string, n, true);
        } else if (object instanceof Section) {
            Methods.cloneSection(section, (Section)object, string, n, true);
        }
    }

    public static void cloneSection(Section section, Object object, String string, int n) {
        Assert.errorParam(section == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "section"));
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "newParent"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "newTitle"));
        if (object instanceof Document) {
            Methods.cloneSection(section, (Document)object, string, n, false);
        } else if (object instanceof Section) {
            Methods.cloneSection(section, (Section)object, string, n, false);
        }
    }

    private static void cloneSection(Section section, Document document, String string, int n, boolean bl) {
        boolean bl2 = true;
        File file = null;
        File file2 = null;
        SectionLoader sectionLoader = null;
        Section section2 = null;
        File file3 = null;
        if (!(!document.hasChapter(string) || document.getChapter(string).equals(section) && bl)) {
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Chapter Title Already Exists", "A chapter with the title \"" + string + "\" already exists within the document.");
            bl2 = false;
        }
        if (bl2) {
            file = FileMethods.createNewTempDirectory();
            file2 = Methods.createSectionFileCopies(section, file);
            sectionLoader = new SectionLoader(document, file2, document.getDocument().getHeaders(), document.getDocument().getFooters(), true);
            section2 = sectionLoader.execute();
            section2.setTitle(string, false);
            section2.isChapter(true, false);
            Methods.changeSectionIds(document.getProject(), section2);
            file3 = new File(document.getRootDirectory(), "Sections");
            FileMethods.copyDirectoryContentsTo(file, file3);
            file2 = new File(file3, section2.getFile().getName());
            document.addChapter(file2, n);
            if (bl) {
                if (section.getParent() instanceof Document) {
                    ((Document)section.getParent()).deleteChapter(section);
                } else if (section.getParent() instanceof Section) {
                    ((Section)section.getParent()).deleteSection(section);
                }
            }
        }
    }

    private static void cloneSection(Section section, Section section2, String string, int n, boolean bl) {
        String string2 = null;
        boolean bl2 = true;
        File file = null;
        File file2 = null;
        SectionLoader sectionLoader = null;
        Section section3 = null;
        if (!(!section2.hasSection(string) || section2.getSection(string).equals(section) && bl)) {
            string2 = section2.isChapter() ? "chapter" : "section";
            PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Section Title Already Exists", "A section with the title \"" + string + "\" already exists within the " + string2 + ".");
            bl2 = false;
        }
        if (bl2) {
            file = FileMethods.createNewTempDirectory();
            file2 = Methods.createSectionFileCopies(section, file);
            sectionLoader = new SectionLoader(section2, file2, section2.getDocument().getHeaders(), section2.getDocument().getFooters(), true);
            section3 = sectionLoader.execute();
            section3.setTitle(string, false);
            section3.isChapter(false, false);
            Methods.changeSectionIds(section2.getProject(), section3);
            FileMethods.copyDirectoryContentsTo(file, section2.getRootDirectory());
            file2 = new File(section2.getRootDirectory(), section3.getFile().getName());
            section2.addSection(file2, n);
            if (bl) {
                if (section.getParent() instanceof Document) {
                    ((Document)section.getParent()).deleteChapter(section);
                } else if (section.getParent() instanceof Section) {
                    ((Section)section.getParent()).deleteSection(section);
                }
            }
        }
    }

    private static File createSectionFileCopies(Section section, File file) {
        File file2 = null;
        file2 = new File(file, section.getFile().getName());
        FileMethods.copyFileTo(section.getFile(), file2);
        for (Section section2 : section.getSections()) {
            Methods.createSectionFileCopies(section2, file);
        }
        return file2;
    }

    private static void changeSectionIds(Project project, Section section) {
        section.setId(project.getNextId());
        for (Section section2 : section.getSections()) {
            Methods.changeSectionIds(project, section2);
        }
        section.saveFile(false);
    }
}

