/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.BlankContentPanel;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.nodes.AbstractNode;
import com.jronimo.documenter.gui.nodes.Methods;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.nodes.SectionNode;
import com.jronimo.documenter.gui.popups.DragAndDropPopup;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.swing.DisplayOptions;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public final class DocumentNode
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(DocumentNode.class);
    private Document document;
    private JMenuItem createChapterMenuItem;
    private JMenuItem reorderChaptersMenuItem;
    private JMenuItem deleteChaptersMenuItem;
    private JMenuItem createDocumentBeforeMenuItem;
    private JMenuItem createDocumentAfterMenuItem;
    private JMenuItem renameDocumentMenuItem;
    private JMenuItem deleteDocumentMenuItem;
    private JPopupMenu popupMenu;

    public DocumentNode(ContainerManager containerManager, Document document) {
        super(containerManager, document, "Document - " + document.getTitle(), true, new Class[]{DocumentNode.class, SectionNode.class});
        this.document = document;
        this.init();
    }

    private void init() {
        List<Section> list = null;
        ActionListenerImpl actionListenerImpl = null;
        list = this.document.getChapters();
        if (list.isEmpty()) {
            this.add(this.dummyChildNode);
        } else {
            for (Section section : list) {
                this.add(new SectionNode(this.containerManager, section));
            }
        }
        actionListenerImpl = new ActionListenerImpl();
        this.createChapterMenuItem = new JMenuItem("Create new chapter...");
        this.createChapterMenuItem.addActionListener(actionListenerImpl);
        this.reorderChaptersMenuItem = new JMenuItem("Reorder chapters...");
        this.reorderChaptersMenuItem.addActionListener(actionListenerImpl);
        this.deleteChaptersMenuItem = new JMenuItem("Delete chapters...");
        this.deleteChaptersMenuItem.addActionListener(actionListenerImpl);
        this.createDocumentBeforeMenuItem = new JMenuItem("Create document before...");
        this.createDocumentBeforeMenuItem.addActionListener(actionListenerImpl);
        this.createDocumentAfterMenuItem = new JMenuItem("Create document after...");
        this.createDocumentAfterMenuItem.addActionListener(actionListenerImpl);
        this.renameDocumentMenuItem = new JMenuItem("Rename document...");
        this.renameDocumentMenuItem.addActionListener(actionListenerImpl);
        this.deleteDocumentMenuItem = new JMenuItem("Delete document...");
        this.deleteDocumentMenuItem.addActionListener(actionListenerImpl);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createChapterMenuItem);
        this.popupMenu.add(this.reorderChaptersMenuItem);
        this.popupMenu.add(this.deleteChaptersMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createDocumentBeforeMenuItem);
        this.popupMenu.add(this.createDocumentAfterMenuItem);
        this.popupMenu.add(this.renameDocumentMenuItem);
        this.popupMenu.add(this.deleteDocumentMenuItem);
        this.completeContextMenu(this.popupMenu);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
    }

    DefaultMutableTreeNode createChildNode(Object object) {
        return new SectionNode(this.containerManager, (Section)object);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getIdPath() {
        return ((Node)((Object)this.getParent())).getIdPath() + "/" + this.document.getId();
    }

    public void setSelected() {
        if (this.containerManager.getCurrentNode() != this) {
            this.containerManager.setContentPanel(new BlankContentPanel(this, this.document.getTitle()));
        }
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void drop(TreeComponent.DropData dropData) {
        Object var2_2 = null;
        SectionNode sectionNode = null;
        boolean bl = true;
        boolean bl2 = false;
        DragAndDropPopup.ConfigStruct configStruct = null;
        DragAndDropPopup.ResultStruct resultStruct = null;
        String string = null;
        boolean bl3 = false;
        Document document = null;
        int n = 0;
        if (!(dropData.getNode() instanceof DocumentNode) && dropData.getNode() instanceof SectionNode && (sectionNode = (SectionNode)dropData.getNode()).getContainerManager().saveCurrentContent()) {
            bl2 = dropData.isMove();
            configStruct = new DragAndDropPopup.ConfigStruct();
            configStruct.sourceValue = "Section - " + sectionNode.getSection().getTitle();
            configStruct.targetValue = "Document - " + this.document.getTitle();
            configStruct.nameLabelText = "Title";
            configStruct.nameValue = sectionNode.getSection().getTitle();
            configStruct.insertBeforeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
            configStruct.insertAfterDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
            configStruct.addAsChildDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.SHOW_SELECTED;
            configStruct.mergeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
            configStruct.deleteSourceDisplayOption = bl2 ? DisplayOptions.CheckBoxDisplayOptions.SHOW_CHECKED : DisplayOptions.CheckBoxDisplayOptions.SHOW_UNCHECKED;
            configStruct.goToDisplayOption = DisplayOptions.CheckBoxDisplayOptions.HIDE;
            resultStruct = PopupFactory.showDragAndDropPopup(Frame.getInstance(), configStruct);
            if (resultStruct != null) {
                string = resultStruct.name;
                bl3 = resultStruct.deleteSource;
                if (resultStruct.action == DragAndDropPopup.Action.ADD_AS_CHILD) {
                    document = this.document;
                    n = this.document.getChapters().size();
                }
                if (bl3 && ApplicationManager.getInstance().clearSelectionFromEditors(sectionNode, true, true)) {
                    Methods.moveSection(sectionNode.getSection(), document, string, n);
                } else {
                    Methods.cloneSection(sectionNode.getSection(), document, string, n);
                }
            }
        }
    }

    private void createChapter() {
        Methods.createChapter(this.document, this.document.getChapters().size());
    }

    private void reorderChapters() {
        List list = null;
        if (ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true) && (list = PopupFactory.showReorderPopup(Frame.getInstance(), "Reorder Chapters", this.document.getChapters())) != null && list.size() > 1) {
            this.document.changeChapterOrder(list);
            ApplicationManager.getInstance().setStatusMessage("Chapters successfully reordered.");
        }
    }

    private void deleteChapters() {
        List<String> list = null;
        String string = null;
        boolean bl = true;
        list = PopupFactory.showListSelectionPopup(Frame.getInstance(), "Select Chapters To Delete", 2, this.document.getChapterTitles(), null);
        if (list != null && list.size() > 0) {
            string = list.size() == 1 ? "Chapter" : "Chapters";
            bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Delete " + string, "Are you sure you want to delete the selected " + string + "?\n\nContent will be deleted and a copy will be placed in the document Deleted Bin.\n");
            if (bl) {
                bl = ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true);
            }
            if (bl) {
                this.document.deleteChapters(list);
                ApplicationManager.getInstance().setStatusMessage(string + " successfully deleted.");
            }
        }
    }

    private void createDocumentBefore() {
        Project project = null;
        project = this.document.getProject();
        Methods.createDocument(project, project.getDocuments().indexOf(this.document));
    }

    private void createDocumentAfter() {
        Project project = null;
        project = this.document.getProject();
        Methods.createDocument(project, project.getDocuments().indexOf(this.document) + 1);
    }

    private void renameDocument() {
        String string = null;
        boolean bl = true;
        string = PopupFactory.showUserInputPopup(Frame.getInstance(), "Rename Document", true, "Document Title", this.document.getTitle());
        if (string != null) {
            if (this.document.getProject().hasDocument(string)) {
                bl = false;
                PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Document Already Exists", "The Document cannot be renamed because a Document with the title \"" + string + "\" already exists.");
            }
            if (bl) {
                this.document.setTitle(string);
                ApplicationManager.getInstance().setStatusMessage("Document successfully renamed: " + string);
            }
        }
    }

    private void deleteDocument() {
        boolean bl = true;
        bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Delete Document", "Are you sure you want to delete the document \"" + this.document.getTitle() + "\"?\n\nContent will be deleted and a copy will be placed in the project Deleted Bin.\n");
        if (bl && ApplicationManager.getInstance().clearSelectionFromEditors(this, true, true)) {
            this.document.getProject().deleteDocument(this.document, true);
            ApplicationManager.getInstance().setStatusMessage("Document successfully deleted: " + this.document.getTitle());
        }
    }

    private void documentUpdated(Document document) {
        if (this.document == document) {
            this.setText("Document - " + document.getTitle());
            this.update(document.getChapters(), true);
        }
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == DocumentNode.this.createChapterMenuItem) {
                DocumentNode.this.createChapter();
            } else if (object == DocumentNode.this.reorderChaptersMenuItem) {
                DocumentNode.this.reorderChapters();
            } else if (object == DocumentNode.this.deleteChaptersMenuItem) {
                DocumentNode.this.deleteChapters();
            } else if (object == DocumentNode.this.createDocumentBeforeMenuItem) {
                DocumentNode.this.createDocumentBefore();
            } else if (object == DocumentNode.this.createDocumentAfterMenuItem) {
                DocumentNode.this.createDocumentAfter();
            } else if (object == DocumentNode.this.renameDocumentMenuItem) {
                DocumentNode.this.renameDocument();
            } else if (object == DocumentNode.this.deleteDocumentMenuItem) {
                DocumentNode.this.deleteDocument();
            }
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void documentUpdated(Documenter.Event event) {
            DocumentNode.this.documentUpdated(event.getDocument());
        }
    }
}

