/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.GuiMethods;
import com.jronimo.documenter.gui.nodes.NoItemsNode;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.swing.TreeComponent;
import com.jronimo.swing.TreeState;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
extends DefaultMutableTreeNode
implements Node {
    private static final Logger logger = Logger.getLogger(AbstractNode.class);
    protected ContainerManager containerManager;
    private Object underlyingObject;
    private Class[] acceptedDropClasses;
    protected DefaultMutableTreeNode dummyChildNode;
    private JMenuItem minimizeMenuItem;
    private JMenuItem maximizeMenuItem;
    private ActionListener contextMenuListener;

    public AbstractNode(ContainerManager containerManager, Object object, String string, boolean bl, Class[] classArray) {
        super(string);
        this.containerManager = containerManager;
        this.underlyingObject = object;
        this.acceptedDropClasses = classArray;
        this.setAllowsChildren(bl);
        if (bl) {
            this.dummyChildNode = new NoItemsNode(this.containerManager);
        }
    }

    abstract DefaultMutableTreeNode createChildNode(Object var1);

    void update(List<Object> list, boolean bl) {
        TreeState treeState = null;
        ArrayList<DefaultMutableTreeNode> arrayList = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        treeState = new TreeState(this.containerManager.getTree(), this);
        if (list.size() == 0) {
            this.removeAllChildren();
            if (bl) {
                this.setAllowsChildren(true);
                this.add(this.dummyChildNode);
            } else {
                this.setAllowsChildren(false);
            }
        } else {
            this.setAllowsChildren(true);
            arrayList = new ArrayList<DefaultMutableTreeNode>(list.size());
            for (Object object : list) {
                defaultMutableTreeNode = this.getChildNodeWithUnderlyingObject(object);
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = this.createChildNode(object);
                }
                arrayList.add(defaultMutableTreeNode);
            }
            this.removeAllChildren();
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : arrayList) {
                this.add(defaultMutableTreeNode2);
            }
        }
        ((DefaultTreeModel)this.containerManager.getTree().getModel()).reload(this);
        treeState.apply(true);
    }

    @Override
    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    @Override
    public void setText(String string) {
        this.setUserObject(string);
    }

    @Override
    public TreePath getTreePath() {
        return new TreePath(this.getPath());
    }

    @Override
    public Object getUnderlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public boolean containsNode(TreeComponent.Node node) {
        return GuiMethods.isDescendantNode((DefaultMutableTreeNode)this, (DefaultMutableTreeNode)((Object)node));
    }

    @Override
    public Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    protected DefaultMutableTreeNode getChildNodeWithUnderlyingObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (((Node)((Object)defaultMutableTreeNode2)).getUnderlyingObject() == null || !((Node)((Object)defaultMutableTreeNode2)).getUnderlyingObject().equals(object)) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
            break;
        }
        return defaultMutableTreeNode;
    }

    protected void completeContextMenu(JPopupMenu jPopupMenu) {
        this.contextMenuListener = new ActionListenerImpl();
        this.minimizeMenuItem = new JMenuItem("Collapse all");
        this.minimizeMenuItem.addActionListener(this.contextMenuListener);
        this.maximizeMenuItem = new JMenuItem("Expand all");
        this.maximizeMenuItem.addActionListener(this.contextMenuListener);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.minimizeMenuItem);
        jPopupMenu.add(this.maximizeMenuItem);
    }

    private void minimizeNode() {
        GuiMethods.collapseAll(this.containerManager.getTree(), this);
    }

    private void maximizeNode() {
        GuiMethods.expandAll(this.containerManager.getTree(), this);
    }

    @Override
    public boolean acceptsDrop(TreeComponent.Node node) {
        boolean bl = false;
        if (node != null && this.acceptedDropClasses != null) {
            for (Class clazz : this.acceptedDropClasses) {
                if (!clazz.equals(node.getClass())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == AbstractNode.this.minimizeMenuItem) {
                AbstractNode.this.minimizeNode();
            } else if (object == AbstractNode.this.maximizeMenuItem) {
                AbstractNode.this.maximizeNode();
            }
        }
    }
}

