/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.Methods;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.nodes.RootNode;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public final class TreePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TreePanel.class);
    private ContainerManager containerManager;
    private int startWidth;
    private java.awt.event.MouseListener mouseListener;
    private TreeSelectionListener treeListener;
    private TreeWillExpandListenerImpl treeWillExpandListener;
    private JTree tree;
    private JSplitPane splitPane;
    private JScrollPane scrollPane;

    public TreePanel(ContainerManager containerManager, int n) {
        this.containerManager = containerManager;
        this.startWidth = n;
        this.initializeMisc();
        this.initializeEventHandlers();
        this.initializeComponents();
        this.initializeContainer();
    }

    private void initializeMisc() {
    }

    private void initializeEventHandlers() {
        this.mouseListener = new MouseListener();
        this.treeWillExpandListener = new TreeWillExpandListenerImpl();
        this.treeListener = new TreeSelectionListenerImpl();
    }

    private void initializeComponents() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = null;
        this.tree = new TreeComponent(Frame.getInstance(), new RootNode(this.containerManager));
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addTreeWillExpandListener(this.treeWillExpandListener);
        this.tree.addTreeSelectionListener(this.treeListener);
        defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setLeafIcon(Methods.getImageIcon("TerminalBullet.png"));
        defaultTreeCellRenderer.setFont(new Font("Helvetica", 1, 14));
        this.tree.setCellRenderer(defaultTreeCellRenderer);
    }

    private void initializeContainer() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JTree jTree = null;
        this.setBackground(Color.white);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jTree = this.tree;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 20, 0);
        gridBagLayout.setConstraints(jTree, gridBagConstraints);
        this.add(jTree);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        int n = 0;
        int n2 = 0;
        if (this.splitPane == null) {
            n2 = this.startWidth;
        } else {
            n = this.scrollPane.getVerticalScrollBar().getWidth() == 0 ? 19 : 4;
            n2 = this.splitPane.getDividerLocation() - n;
        }
        dimension = new Dimension(n2, super.getPreferredSize().height);
        return dimension;
    }

    void setSplitPane(JSplitPane jSplitPane) {
        this.splitPane = jSplitPane;
    }

    void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    void setInitialTreeState() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = null;
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    JTree getTree() {
        return this.tree;
    }

    public class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Node node = null;
            node = (Node)TreePanel.this.tree.getLastSelectedPathComponent();
        }
    }

    public class TreeWillExpandListenerImpl
    implements TreeWillExpandListener {
        private TreeWillExpandListenerImpl() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            if (!TreePanel.this.containerManager.clearSelection((Node)treeExpansionEvent.getPath().getLastPathComponent(), false, true)) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }
    }

    public class MouseListener
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath = null;
            if (mouseEvent.isPopupTrigger() && (treePath = TreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                ((Node)treePath.getLastPathComponent()).showContextMenu(mouseEvent);
            }
        }
    }
}

