/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.util.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public final class TreeDragNDropHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(TreeDragNDropHandler.class);
    private static final DataFlavor DATA_FLAVOR = new DataFlavor(TreePath.class, "TreePath");
    private JTree tree;
    private TransferHandler originalTransferHandler;

    public TreeDragNDropHandler(JTree jTree) {
        this.tree = jTree;
        this.originalTransferHandler = jTree.getTransferHandler();
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        if (jComponent == this.tree) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!DATA_FLAVOR.equals(dataFlavor)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (jComponent != this.tree || transferable instanceof TransferableData) {
            // empty if block
        }
        return true;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (jComponent != this.tree || n == 2) {
            // empty if block
        }
    }

    protected Transferable createTransferable(JComponent jComponent) {
        Transferable transferable = null;
        return transferable;
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return this.originalTransferHandler.getVisualRepresentation(transferable);
    }

    public class TransferableData
    implements Transferable {
        private TreePath treePath;

        public TransferableData(TreePath treePath) {
            this.treePath = treePath;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            TreePath treePath = null;
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            treePath = this.treePath;
            return treePath;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DATA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DATA_FLAVOR.equals(dataFlavor);
        }
    }
}

