/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ShutdownManager;
import com.jronimo.swing.GuiMethods;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public final class MenuBar
extends JMenuBar {
    private ActionListener listener = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem addTabMenuItem = null;
    private JMenuItem removeCurrentTabMenuItem = null;
    private JMenuItem reorderTabsMenuItem = null;
    private JMenuItem helpFileMenuItem = null;
    private JMenuItem aboutMenuItem = null;

    public MenuBar() {
        this.initializeEventHandlers();
        this.initializeComponents();
        this.initializeContainer();
    }

    private void initializeEventHandlers() {
        this.listener = new ActionListenerImpl();
    }

    private void initializeComponents() {
        this.constructFileMenu();
        this.constructTabsMenu();
        this.constructHelpMenu();
    }

    private void initializeContainer() {
    }

    private void constructFileMenu() {
        JMenu jMenu = null;
        Object var2_2 = null;
        jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.add(jMenu);
        this.exitMenuItem = new JMenuItem("Exit", 88);
        this.exitMenuItem.addActionListener(this.listener);
        jMenu.add(this.exitMenuItem);
    }

    private void constructTabsMenu() {
        JMenu jMenu = null;
        Object var2_2 = null;
        jMenu = new JMenu("Tabs");
        jMenu.setMnemonic(84);
        this.add(jMenu);
        this.addTabMenuItem = new JMenuItem("Add tab", 65);
        this.addTabMenuItem.addActionListener(this.listener);
        jMenu.add(this.addTabMenuItem);
        this.removeCurrentTabMenuItem = new JMenuItem("Remove current tab", 82);
        this.removeCurrentTabMenuItem.addActionListener(this.listener);
        jMenu.add(this.removeCurrentTabMenuItem);
        this.reorderTabsMenuItem = new JMenuItem("Reorder tabs...", 79);
        this.reorderTabsMenuItem.addActionListener(this.listener);
        this.reorderTabsMenuItem.setEnabled(false);
        jMenu.add(this.reorderTabsMenuItem);
    }

    private void constructHelpMenu() {
        JMenu jMenu = null;
        Object var2_2 = null;
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        this.add(jMenu);
        this.helpFileMenuItem = new JMenuItem("Help File", 72);
        this.helpFileMenuItem.setEnabled(false);
        this.helpFileMenuItem.addActionListener(this.listener);
        jMenu.add(this.helpFileMenuItem);
        this.aboutMenuItem = new JMenuItem("About", 65);
        this.aboutMenuItem.setEnabled(false);
        this.aboutMenuItem.addActionListener(this.listener);
        jMenu.add(this.aboutMenuItem);
    }

    private void disableAll() {
        this.setEnabled(false);
    }

    private void enableAll() {
        this.setEnabled(true);
    }

    private void addTab() {
        Thread thread = null;
        thread = new Thread(new Runnable(){

            public void run() {
                ApplicationManager.getInstance().addNewTab();
            }
        });
        GuiMethods.startEventThread(thread);
    }

    private void removeCurrentTab() {
        Thread thread = null;
        thread = new Thread(new Runnable(){

            public void run() {
                ApplicationManager.getInstance().removeCurrentTab();
            }
        });
        GuiMethods.startEventThread(thread);
    }

    private void reorderTabs() {
        Thread thread = null;
        thread = new Thread(new Runnable(){

            public void run() {
                ApplicationManager.getInstance().reorderTabs();
            }
        });
        GuiMethods.startEventThread(thread);
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == MenuBar.this.exitMenuItem) {
                ShutdownManager.getInstance().shutdown();
            } else if (object == MenuBar.this.addTabMenuItem) {
                MenuBar.this.addTab();
            } else if (object == MenuBar.this.removeCurrentTabMenuItem) {
                MenuBar.this.removeCurrentTab();
            } else if (object == MenuBar.this.reorderTabsMenuItem) {
                MenuBar.this.reorderTabs();
            }
        }
    }
}

