/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.StartupManager;
import com.jronimo.swing.AppLock;
import com.jronimo.util.Logger;
import java.io.File;

public final class Main {
    private static final Logger logger = Logger.getLogger(Main.class);

    Main() {
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            if (Main.getAppLock()) {
                bl = true;
                StartupManager.getInstance().startup(Main.getApplicationFolderPath(stringArray));
                Main.releaseAppLock();
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                Main.releaseAppLock();
            }
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    private static boolean getAppLock() {
        boolean bl = false;
        try {
            bl = AppLock.setLock("TobiscoDocumenter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            throw new RuntimeException("Already running.");
        }
        return bl;
    }

    private static void releaseAppLock() {
        try {
            AppLock.releaseLock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getApplicationFolderPath(String[] stringArray) {
        String string = null;
        string = stringArray.length == 0 ? Main.getApplicationFolderPathFromJar() : stringArray[0];
        return string;
    }

    private static String getApplicationFolderPathFromJar() {
        String string = null;
        int n = 0;
        string = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (string.indexOf(":") >= 0 && string.startsWith("/")) {
            string = string.substring(1);
        }
        while ((n = string.indexOf("%20")) >= 0) {
            string = string.substring(0, n) + " " + string.substring(n + 3);
        }
        string = new File(string).getParentFile().getPath();
        return string;
    }
}

