/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ComponentFactory;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.TreePanel;
import com.jronimo.util.Logger;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public final class EditorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(EditorPanel.class);
    private static final Cursor cursor = new Cursor(3);
    private ContainerManager containerManager;
    private TreePanel treePanel;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;

    public EditorPanel(ContainerManager containerManager) {
        this.containerManager = containerManager;
        this.initializeEventHandlers();
        this.initializeComponents();
        this.initializeContainers();
    }

    private void initializeEventHandlers() {
    }

    private void initializeComponents() {
        this.treePanel = new TreePanel(this.containerManager, 330);
        this.scrollPane = ComponentFactory.getScrollPane(this.treePanel, 20, 31);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(new ScrollBarListener());
        this.splitPane = new JSplitPane(1, true, this.scrollPane, new JPanel());
        this.splitPane.setDividerLocation(330);
        this.splitPane.setOneTouchExpandable(true);
        this.treePanel.setSplitPane(this.splitPane);
        this.treePanel.setScrollPane(this.scrollPane);
    }

    private void initializeContainers() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JSplitPane jSplitPane = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jSplitPane = this.splitPane;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
        this.add(jSplitPane);
    }

    private void disableAll() {
        this.setCursor(cursor);
    }

    private void enableAll() {
        this.setCursor(null);
    }

    void setDividerLocation(int n) {
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
        }
    }

    int getScrollLocation() {
        return this.scrollPane.getVerticalScrollBar().getValue();
    }

    void setScrollLocation(int n) {
        if (n > 0) {
            this.scrollPane.getVerticalScrollBar().setValue(n);
        }
    }

    int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    void setInitialTreeState() {
        this.treePanel.setInitialTreeState();
    }

    JTree getTree() {
        return this.treePanel.getTree();
    }

    JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    public class SplitPanePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            logger.debug("event.getPropertyName(): " + propertyChangeEvent.getPropertyName());
        }
    }

    public class ScrollBarListener
    implements AdjustmentListener {
        private ScrollBarListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            EditorPanel.this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
    }
}

