/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.documenter.gui.ApplicationProperties;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.RootPanel;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.swing.StatusMessage;
import com.jronimo.swing.TreeState;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.EventFirer;
import com.jronimo.util.Logger;
import com.jronimo.util.MethodInvoker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationManager {
    private static ApplicationManager instance;
    public static final long STATUS_MESSAGE_TIMEOUT = 3000L;
    private static final Logger logger;
    private File applicationFolder = null;
    private File applicationDataFolder = null;
    private File defaultDocumentsFolder = null;
    private List<Listener> listeners = new ArrayList<Listener>(1);
    private File tabsXmlFile;
    private List<ContainerManager> containerManagers = new ArrayList<ContainerManager>(1);
    private RootPanel rootPanel;
    private int editorLoadingCount;

    private ApplicationManager(File file, File file2, File file3) {
        this.applicationFolder = file;
        this.applicationDataFolder = file2;
        this.defaultDocumentsFolder = file3;
        this.init();
    }

    private void init() {
        ApplicationProperties.createInstance(this.applicationDataFolder);
        this.tabsXmlFile = new File(this.applicationDataFolder, "Tabs.xml");
        this.loadContainerManagers();
    }

    public static void createInstance(File file, File file2, File file3) {
        instance = new ApplicationManager(file, file2, file3);
    }

    public static ApplicationManager getInstance() {
        return instance;
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void guiLoaded() {
        this.rootPanel = Frame.getInstance().getRootPanel();
        for (ContainerManager containerManager : this.getContainerManagers()) {
            containerManager.loadEditor();
            this.rootPanel.addEditor(containerManager);
        }
        for (ContainerManager containerManager : this.getContainerManagers()) {
            containerManager.setEditorState();
        }
    }

    public File getApplicationFolder() {
        return this.applicationFolder;
    }

    public File getApplicationDataFolder() {
        return this.applicationDataFolder;
    }

    public File getDefaultDocumentsFolder() {
        return this.defaultDocumentsFolder;
    }

    public Documenter getDocumenter() {
        return Documenter.getInstance();
    }

    public List<ContainerManager> getContainerManagers() {
        return CollectionUtils.collectionToList(this.containerManagers);
    }

    public void addContainerManager(ContainerManager containerManager) {
        this.containerManagers.add(containerManager);
    }

    public boolean removeContainerManager(ContainerManager containerManager) {
        boolean bl = false;
        bl = containerManager.prepareForDestroy();
        if (bl) {
            containerManager.destroy();
            this.containerManagers.remove(containerManager);
        }
        return bl;
    }

    public void setReorderedContainerManagers(List<ContainerManager> list) {
        this.containerManagers = list;
    }

    public void setRootPanel(RootPanel rootPanel) {
        this.rootPanel = rootPanel;
    }

    public synchronized void contentPanelLoading() {
        Frame.getInstance().showGlassPane();
        ++this.editorLoadingCount;
    }

    public synchronized void contentPanelReady() {
        if (--this.editorLoadingCount == 0) {
            Frame.getInstance().hideGlassPane();
        }
    }

    public void addNewTab() {
        this.rootPanel.addNewTab();
    }

    public void removeCurrentTab() {
        this.rootPanel.removeCurrentTab();
    }

    public void reorderTabs() {
    }

    public boolean isNodeSelected(ContainerManager containerManager, Node node) {
        boolean bl = false;
        String string = null;
        string = node.getTreePath().toString();
        for (ContainerManager containerManager2 : this.getContainerManagers()) {
            if (containerManager2 == containerManager || containerManager2.getCurrentNode() == null || !containerManager2.getCurrentNode().getTreePath().toString().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean clearSelectionFromEditors(Node node, boolean bl, boolean bl2) {
        ContainerManager containerManager;
        boolean bl3 = true;
        Iterator<ContainerManager> iterator = this.containerManagers.iterator();
        while (iterator.hasNext() && (bl3 = (containerManager = iterator.next()).clearSelection(node, bl, bl2))) {
        }
        return bl3;
    }

    public void setStatusMessage(String string) {
        ListenerAdapter.fireEvent(this.listeners, "statusMessageChanged", new Event(new StatusMessage(string, 3000L)));
    }

    public void setStatusErrorMessage(String string, String string2) {
        StatusMessage statusMessage = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "title"));
        Assert.errorParam(string.trim().length() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "title"));
        Assert.errorParam(string2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "message"));
        Assert.errorParam(string2.trim().length() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "message"));
        PopupFactory.showPopupErrorMessage(Frame.getInstance(), string, string2);
        statusMessage = new StatusMessage(string, string2, true, true, 3000L);
        ListenerAdapter.fireEvent(this.listeners, "statusMessageChanged", new Event(statusMessage));
    }

    public synchronized boolean saveForExit() {
        boolean bl = true;
        boolean bl2 = false;
        for (ContainerManager containerManager : this.getContainerManagers()) {
            bl2 = containerManager.prepareForDestroy();
            if (bl2) continue;
            bl = false;
        }
        if (bl) {
            this.saveTabsXmlFile();
            for (ContainerManager containerManager : this.getContainerManagers()) {
                containerManager.destroy();
            }
        }
        return bl;
    }

    private void loadContainerManagers() {
        for (XmlElement xmlElement : XmlElementFactory.load(this.tabsXmlFile).getElements("tab")) {
            this.containerManagers.add(new ContainerManager(xmlElement));
        }
    }

    private synchronized void saveTabsXmlFile() {
        TreeState.Struct struct = null;
        XmlElement xmlElement = null;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        String string = null;
        if (this.rootPanel != null) {
            xmlElement = XmlElementFactory.create("tabs");
            n3 = this.rootPanel.getCurrentTabIndex();
            for (ContainerManager containerManager : this.getContainerManagers()) {
                ++n;
                struct = containerManager.getNodeInfo();
                if (struct == null) continue;
                ++n2;
                xmlElement2 = xmlElement.addElement("tab");
                if (n == n3) {
                    xmlElement2.setAttributeBoolean("selected", true);
                }
                xmlElement3 = xmlElement2.addElement("expanded-nodes");
                for (DefaultMutableTreeNode defaultMutableTreeNode : struct.expandedNodes) {
                    xmlElement3.addElement("node").setText(((Node)((Object)defaultMutableTreeNode)).getIdPath());
                }
                string = struct.selectedNode == null ? "" : ((Node)((Object)struct.selectedNode)).getIdPath();
                xmlElement2.addElement("selected-node").setText(string);
                xmlElement2.addElement("divider-location").setInteger(containerManager.getEditorPanel().getDividerLocation());
                xmlElement2.addElement("scroll-location").setInteger(containerManager.getEditorPanel().getScrollLocation());
            }
            if (n2 > 0) {
                xmlElement.save(this.tabsXmlFile);
            }
        }
    }

    static {
        logger = Logger.getLogger(ApplicationManager.class);
    }

    public static class ListenerAdapter
    implements Listener {
        private static void fireEvent(Collection collection, String string, Event event) {
            new EventFirer(collection, ListenerAdapter.getMethodInvoker(string, event)).execute(true);
        }

        private static MethodInvoker getMethodInvoker(String string, Event event) {
            return new MethodInvoker(Listener.class, null, string, null, new Object[]{event});
        }

        public void statusMessageChanged(Event event) {
        }
    }

    public static interface Listener {
        public void statusMessageChanged(Event var1);
    }

    public class Event {
        private ApplicationManager applicationManager;
        private Object subject;

        private Event(Object object) {
            this.applicationManager = ApplicationManager.this;
            this.subject = object;
        }

        public ApplicationManager getApplicationManager() {
            return this.applicationManager;
        }

        public Object getSubject() {
            return this.subject;
        }

        public StatusMessage getStatusMessage() {
            return (StatusMessage)this.subject;
        }
    }
}

