/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.constraints;

import com.jronimo.constraints.ValidationOutcome;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.internationalization.Language;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.text.TextSource;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.util.Collection;
import java.util.Locale;

public final class Constraint {
    private static final Logger logger = Logger.getLogger(Constraint.class);
    private ConstraintType type;
    private String name;
    private ValueMultiplicity valueMultiplicity;
    private boolean requiresNonNullValue;
    private String methodName;

    public Constraint(ConstraintType constraintType, String string, ValueMultiplicity valueMultiplicity, boolean bl) {
        this.type = constraintType;
        this.name = string;
        this.valueMultiplicity = valueMultiplicity;
        this.requiresNonNullValue = bl;
        this.methodName = new SimpleNameFormat(string).getHungarian();
    }

    public ConstraintType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ValueMultiplicity getValueMultiplicity() {
        return this.valueMultiplicity;
    }

    public boolean requiresNonNullValue() {
        return this.requiresNonNullValue;
    }

    public ValidationOutcome execute(ConstraintCallStruct constraintCallStruct) {
        ValidationOutcome validationOutcome = null;
        String string = null;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Object object = null;
        try {
            this.validateCallStruct(constraintCallStruct);
            string = this.getClass().getPackage().toString() + "." + new SimpleNameFormat(this.type.toString()).getCamelCase();
            clazz = Class.forName(string + "Constraints");
            clazz2 = Class.forName(string + "ConstraintInputs");
            object = Methods.instantiateViaReflection(clazz2, ConstraintCallStruct.class, constraintCallStruct);
            validationOutcome = (ValidationOutcome)Methods.executeViaReflection(clazz, null, this.methodName, false, clazz2, object);
        }
        catch (UnexpectedErrorException unexpectedErrorException) {
            throw unexpectedErrorException;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return validationOutcome;
    }

    private void validateCallStruct(ConstraintCallStruct constraintCallStruct) {
        Assert.errorParam(constraintCallStruct == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.fieldName"));
        Assert.errorParam(constraintCallStruct.fieldName == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.fieldName"));
        Assert.errorParam(this.requiresNonNullValue && constraintCallStruct.value == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.value"));
        Assert.errorParam(this.valueMultiplicity == ValueMultiplicity.ONE && constraintCallStruct.constraintValue == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.constraintValue"));
        Assert.errorParam(this.valueMultiplicity == ValueMultiplicity.MANY && constraintCallStruct.constraintValues == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.constraintValues"));
        Assert.errorParam(constraintCallStruct.language == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.language"));
        Assert.errorParam(constraintCallStruct.locale == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "callStruct.locale"));
    }

    public static class ConstraintCallStruct {
        public String fieldName;
        public Object value;
        public Object constraintValue;
        public Collection<Object> constraintValues;
        public Language language;
        public Locale locale;
        public TextSource textSource;
        public Boolean useTimezones;

        public ConstraintCallStruct cloneInstance() {
            ConstraintCallStruct constraintCallStruct = null;
            constraintCallStruct = new ConstraintCallStruct();
            constraintCallStruct.fieldName = this.fieldName;
            constraintCallStruct.value = this.value;
            constraintCallStruct.constraintValue = this.constraintValue;
            constraintCallStruct.constraintValues = this.constraintValues;
            constraintCallStruct.language = this.language;
            constraintCallStruct.locale = this.locale;
            constraintCallStruct.textSource = this.textSource;
            constraintCallStruct.useTimezones = this.useTimezones;
            return constraintCallStruct;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueMultiplicity {
        NONE,
        ONE,
        MANY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstraintType {
        STRING,
        WHOLE_NUMBER,
        DECIMAL_NUMBER,
        BOOLEAN,
        BINARY,
        DATE,
        DATE_TIME,
        TIME_OF_DAY,
        TIME;

    }
}

