/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.exceptions;

import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;

public final class ExceptionDetails {
    private static final Logger logger = Logger.getLogger(ExceptionDetails.class);
    private ExceptionType exceptionType;
    private String message = null;
    private Throwable throwable;

    protected ExceptionDetails(ExceptionType exceptionType, ResourceTextPointer resourceTextPointer) {
        Assert.errorParamMustNotBeNull("exceptionType", (Object)exceptionType);
        Assert.errorParamMustNotBeNull("message", resourceTextPointer);
        this.exceptionType = exceptionType;
        this.message = ExceptionDetails.appendToMessage(resourceTextPointer.getText());
    }

    protected ExceptionDetails(ExceptionType exceptionType, Throwable throwable) {
        Assert.errorParamMustNotBeNull("exceptionType", (Object)exceptionType);
        Assert.errorParamMustNotBeNull("throwable", throwable);
        this.exceptionType = exceptionType;
        this.throwable = throwable;
    }

    public ExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isUnemptyException() {
        return this.exceptionType == ExceptionType.UNEMPTY;
    }

    public boolean isNullFreeException() {
        return this.exceptionType == ExceptionType.NULL_FREE;
    }

    public boolean isSortingConflictException() {
        return this.exceptionType == ExceptionType.SORTING_CONFLICT;
    }

    public boolean isFixedSizeException() {
        return this.isMinSizeException() || this.isMaxSizeException();
    }

    public boolean isMinSizeException() {
        return this.exceptionType == ExceptionType.MIN_SIZE;
    }

    public boolean isMaxSizeException() {
        return this.exceptionType == ExceptionType.MAX_SIZE;
    }

    public boolean isRestrictionException() {
        return this.isRestrictedToException() || this.isRestrictedFromException();
    }

    public boolean isRestrictedToException() {
        return this.exceptionType == ExceptionType.RESTRICTED_TO;
    }

    public boolean isRestrictedFromException() {
        return this.exceptionType == ExceptionType.RESTRICTED_FROM;
    }

    static String appendToMessage(String string) {
        StringBuilder stringBuilder = null;
        if (string != null) {
            stringBuilder = new StringBuilder(string);
            stringBuilder.append(" ");
            stringBuilder.append(new ResourceTextPointer((Object)ResourceTextIdentifiers.NO_CHANGES_MADE).getText());
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    static String getValueString(Object object, CollectionParameters.Restrictions.ValueMethod valueMethod) {
        String string = null;
        Object object2 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        if (object == null) {
            string = " (" + String.valueOf(null) + ")";
        } else if (valueMethod != null) {
            try {
                if (valueMethod.useToString()) {
                    object2 = object;
                } else if (valueMethod.getValueMethod() != null) {
                    object2 = valueMethod.getValueMethod().invoke(object, new Object[0]);
                }
                stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(object2);
                if (valueMethod.surroundValueWithQuotes()) {
                    stringWrapperWithVoidRegions.surround("\"");
                }
                stringWrapperWithVoidRegions.insert(0, " (");
                stringWrapperWithVoidRegions.append(")");
                string = stringWrapperWithVoidRegions.toString();
            }
            catch (Exception exception) {
                logger.warning(exception);
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExceptionType {
        IMMUTABLE,
        UNEMPTY,
        NULL_FREE,
        EXTERNAL_SORT_NOT_SUPPORTED,
        SORTING_CONFLICT,
        MIN_SIZE,
        MAX_SIZE,
        RESTRICTION_VALIDATOR,
        RESTRICTED_TO,
        RESTRICTED_FROM;

    }
}

