/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.types.surf.RestrictedCollection;
import com.jronimo.collections.exceptions.RestrictedFromException;
import com.jronimo.collections.exceptions.RestrictedToException;
import com.jronimo.collections.exceptions.RestrictionValidatorException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RestrictedDecorator<E>
extends AbstractDecorator<E>
implements RestrictedCollection<E> {
    private CollectionParameters.Restrictions restrictions;

    RestrictedDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain, CollectionParameters.Restrictions restrictions) {
        super(collection, decoratorChain);
        Iterator<E> iterator = null;
        Object var5_5 = null;
        this.restrictions = restrictions;
        if (this.restrictions != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                var5_5 = iterator.next();
                if (restrictions.getConstructionFailSilent()) {
                    if (!restrictions.failsRestrictions(var5_5)) continue;
                    iterator.remove();
                    continue;
                }
                this.failValue(var5_5);
            }
        }
    }

    private void failValue(Object object) {
        String string = null;
        if (this.restrictions != null) {
            string = this.restrictions.failsValidator(object);
            if (string != null) {
                throw new RestrictionValidatorException(string);
            }
            if (this.restrictions.failsRestrictedTo(object)) {
                throw new RestrictedToException(object, this.restrictions.getValueMethod());
            }
            if (this.restrictions.failsRestrictedFrom(object)) {
                throw new RestrictedFromException(object, this.restrictions.getValueMethod());
            }
        }
    }

    private void failCollectionValues(com.jronimo.collections.collection.types.Collection<?> collection) {
        if (this.restrictions != null) {
            for (Object obj : collection) {
                this.failValue(obj);
            }
        }
    }

    @Override
    public boolean isRestricted() {
        return true;
    }

    @Override
    public boolean isRestrictedTo() {
        return this.restrictions != null && this.restrictions.hasRestrictedTo();
    }

    @Override
    public boolean isRestrictedFrom() {
        return this.restrictions != null && this.restrictions.hasRestrictedFrom();
    }

    @Override
    public boolean isValidValue(E e) {
        boolean bl = false;
        if (!this.restrictions.failsRestrictions(e)) {
            bl = this.wrapped.isValidValue(e);
        }
        return bl;
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        this.failValue(e);
        bl = this.wrapped.add(e);
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        this.failCollectionValues((com.jronimo.collections.collection.types.Collection)collection);
        bl = this.wrapped.addAll(collection);
        return bl;
    }

    @Override
    public void add(int n, E e) {
        this.failValue(e);
        this.wrapped.add(n, e);
    }

    @Override
    public boolean addBefore(Object object, E e) {
        boolean bl = false;
        this.failValue(e);
        bl = this.wrapped.addBefore(object, e);
        return bl;
    }

    @Override
    public boolean addAfter(Object object, E e) {
        boolean bl = false;
        this.failValue(e);
        bl = this.wrapped.addAfter(object, e);
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = false;
        this.failCollectionValues((com.jronimo.collections.collection.types.Collection)collection);
        bl = this.wrapped.addAll(n, collection);
        return bl;
    }

    @Override
    public E set(int n, E e) {
        E e2 = null;
        this.failValue(e);
        e2 = this.wrapped.set(n, e);
        return e2;
    }

    @Override
    public boolean set(Object object, E e) {
        boolean bl = false;
        this.failValue(e);
        bl = this.wrapped.set(object, e);
        return bl;
    }

    public static <E> com.jronimo.collections.collection.types.Collection<E> decorate(com.jronimo.collections.collection.types.Collection<E> collection, CollectionParameters.Restrictions restrictions) {
        com.jronimo.collections.collection.types.Collection<E> collection2 = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        Assert.errorParam(restrictions == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "restrictions"));
        for (E e : collection) {
            if (restrictions.failsRestrictedTo(e)) {
                throw new RestrictedToException(e, restrictions.getValueMethod());
            }
            if (!restrictions.failsRestrictedFrom(e)) continue;
            throw new RestrictedFromException(e, restrictions.getValueMethod());
        }
        collection2 = DecoratorChain.decorate(collection, new DecoratorChain.DecorationStruct(DecoratorRegistry.getDecoratorConfig(RestrictedDecorator.class)).setRestrictions(restrictions));
        return collection2;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(RestrictedDecorator.class, RestrictedCollection.class));
    }
}

