/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.hidden.impl.ListIterator;
import com.jronimo.collections.collection.hidden.impl.OrderedCollection;
import com.jronimo.collections.collection.types.ListCollection;
import com.jronimo.collections.collection.types.SetCollection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertDecorator<E>
extends AbstractDecorator<E> {
    private OrderedCollection<E> orderedCollection = this.getDecoratorChainInstance().getOrderedCollection();

    AssertDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain) {
        super(collection, decoratorChain);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        Assert.notEmpty(collection, "collection");
        bl = this.wrapped.containsAll(collection);
        return bl;
    }

    @Override
    public boolean containsAll(Object ... objectArray) {
        boolean bl = false;
        Assert.notNull(objectArray);
        Assert.notEmpty(objectArray, "array");
        bl = this.wrapped.containsAll(objectArray);
        return bl;
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        bl = this.wrapped.containsAny(collection);
        return bl;
    }

    @Override
    public boolean containsAny(Object ... objectArray) {
        boolean bl = false;
        Assert.notNull(objectArray);
        bl = this.wrapped.containsAny(objectArray);
        return bl;
    }

    @Override
    public boolean containsOnly(Collection<?> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        Assert.notEmpty(collection, "collection");
        bl = this.wrapped.containsOnly(collection);
        return bl;
    }

    @Override
    public boolean containsOnly(Object ... objectArray) {
        boolean bl = false;
        Assert.notNull(objectArray);
        Assert.notEmpty(objectArray, "array");
        bl = this.wrapped.containsOnly(objectArray);
        return bl;
    }

    @Override
    public E get(Object object) {
        E e = null;
        Assert.notNull(object);
        e = this.wrapped.get(object);
        return e;
    }

    @Override
    public SetCollection<E> get(SetCollection<Object> setCollection) {
        SetCollection setCollection2 = null;
        Assert.notNull(setCollection);
        setCollection2 = this.wrapped.get(setCollection);
        return setCollection2;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(Object object) {
        com.jronimo.collections.collection.types.Collection collection = null;
        Assert.notNull(object);
        collection = this.wrapped.getAll(object);
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(SetCollection<Object> setCollection) {
        com.jronimo.collections.collection.types.Collection collection = null;
        Assert.notNull(setCollection);
        collection = this.wrapped.getAll(setCollection);
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(Object ... objectArray) {
        com.jronimo.collections.collection.types.Collection collection = null;
        Assert.notNull(objectArray);
        collection = this.wrapped.getAll(objectArray);
        return collection;
    }

    @Override
    public ListCollection<E> subList(int n, int n2) {
        ListCollection listCollection = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, true), true);
        Assert.errorParam(n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "toIndex", n2, "fromIndex"), IndexOutOfBoundsException.class);
        listCollection = this.wrapped.subList(n, n2);
        return listCollection;
    }

    @Override
    public Iterator<E> iterator(int n) {
        Iterator iterator = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        iterator = this.wrapped.iterator(n);
        return iterator;
    }

    @Override
    public Iterator<E> iterator(int n, int n2) {
        Iterator iterator = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, true), true);
        Assert.errorParam(n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "toIndex", n2, "fromIndex"), IndexOutOfBoundsException.class);
        iterator = this.wrapped.iterator(n, n2);
        return iterator;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        ListIterator listIterator = null;
        listIterator = this.wrapped.listIterator(n);
        return listIterator;
    }

    @Override
    public ListIterator<E> listIterator(int n, int n2) {
        ListIterator listIterator = null;
        listIterator = this.wrapped.listIterator(n, n2);
        return listIterator;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2 = null;
        Assert.notNull(TArray);
        TArray2 = this.wrapped.toArray(TArray);
        return TArray2;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        bl = this.wrapped.addAll(collection);
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        bl = this.wrapped.removeAll(collection);
        return bl;
    }

    @Override
    public boolean removeAll(Object ... objectArray) {
        boolean bl = false;
        Assert.notNull(objectArray);
        bl = this.wrapped.removeAll(objectArray);
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        bl = this.wrapped.retainAll(collection);
        return bl;
    }

    @Override
    public void sort(Comparator comparator) {
        Assert.notNull(comparator);
        this.wrapped.sort(comparator);
    }

    @Override
    public E get(int n) {
        E e = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        e = this.wrapped.get(n);
        return e;
    }

    @Override
    public E getFromLast(int n) {
        E e = null;
        CollectionUtils.indexInBounds(this.orderedCollection.size() - 1 - n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        e = this.wrapped.getFromLast(n);
        return e;
    }

    @Override
    public void add(int n, E e) {
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        this.wrapped.add(n, e);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = false;
        Assert.notNull(collection);
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        bl = this.wrapped.addAll(n, collection);
        return bl;
    }

    @Override
    public E set(int n, E e) {
        E e2 = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        e2 = this.wrapped.set(n, e);
        return e2;
    }

    @Override
    public boolean move(int n, int n2) {
        boolean bl = false;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, true), true);
        bl = this.wrapped.move(n, n2);
        return bl;
    }

    @Override
    public boolean move(Object object, int n) {
        boolean bl = false;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        bl = this.wrapped.move(object, n);
        return bl;
    }

    @Override
    public boolean swap(int n, int n2) {
        boolean bl = false;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, false), true);
        bl = this.wrapped.swap(n, n2);
        return bl;
    }

    @Override
    public E remove(int n) {
        E e = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        e = this.wrapped.remove(n);
        return e;
    }

    @Override
    public E removeFromLast(int n) {
        E e = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, false), true);
        e = this.wrapped.removeFromLast(n);
        return e;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n) {
        com.jronimo.collections.collection.types.Collection collection = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        collection = this.wrapped.removeAllFrom(n);
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n, int n2) {
        com.jronimo.collections.collection.types.Collection collection = null;
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, true), true);
        Assert.errorParam(n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "toIndex", n2, "fromIndex"), IndexOutOfBoundsException.class);
        collection = this.wrapped.removeAllFrom(n, n2);
        return collection;
    }

    @Override
    public E removeFirst() {
        E e = null;
        e = this.wrapped.removeFirst();
        return e;
    }

    @Override
    public E removeLast() {
        E e = null;
        e = this.wrapped.removeLast();
        return e;
    }

    private int getMaxIndex(Collection<?> collection, boolean bl) {
        int n = 0;
        n = collection.isEmpty() ? 0 : (bl ? collection.size() : collection.size() - 1);
        return n;
    }

    @Override
    public String toString(String string, int n, int n2) {
        String string2 = null;
        Assert.notNull(string);
        CollectionUtils.indexInBounds(n, 0, this.getMaxIndex(this.orderedCollection, true), true);
        CollectionUtils.indexInBounds(n2, 0, this.getMaxIndex(this.orderedCollection, true), true);
        Assert.errorParam(n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "toIndex", n2, "fromIndex"), IndexOutOfBoundsException.class);
        string2 = this.wrapped.toString(string, n, n2);
        return string2;
    }

    @Override
    public String toString(String string) {
        String string2 = null;
        Assert.notNull(string);
        string2 = this.wrapped.toString(string);
        return string2;
    }

    @Override
    public String toString() {
        String string = null;
        string = ((Object)this.wrapped).toString();
        return string;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(AssertDecorator.class, null));
    }
}

