/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection;

import com.jronimo.collections.collection.decorations.ImmutableSet_U;
import com.jronimo.collections.collection.decorations.NullFreeImmutableSet_U;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.SetUtils;

public class CollectionParameters
implements Cloneable {
    private static final Logger logger = Logger.getLogger(CollectionParameters.class);
    protected int capacity = 10;
    protected ComparatorConfig comparatorConfig;
    protected Restrictions restrictions;
    protected FixedSize fixedSize;
    protected boolean constructionFailSilentNullFree = true;
    protected boolean useSynchronization;

    public CollectionParameters() {
    }

    public CollectionParameters(int n) {
        Assert.errorParam(n < 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "capacity", n, 0));
        this.capacity = n;
    }

    public void setCapacity(int n) {
        Assert.errorParam(n < 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "value", n, 0));
        this.capacity = n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setComparatorConfig(ComparatorConfig comparatorConfig) {
        this.comparatorConfig = comparatorConfig;
    }

    public ComparatorConfig getComparatorConfig() {
        return this.comparatorConfig;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public void setFixedSize(FixedSize fixedSize) {
        this.fixedSize = fixedSize;
    }

    public FixedSize getFixedSize() {
        return this.fixedSize;
    }

    public CollectionParameters setConstructionFailSilentNullFree(boolean bl) {
        this.constructionFailSilentNullFree = bl;
        return this;
    }

    public boolean getConstructionFailSilentNullFree() {
        return this.constructionFailSilentNullFree;
    }

    public CollectionParameters setUseSynchronization(boolean bl) {
        this.useSynchronization = bl;
        return this;
    }

    public boolean getUseSynchronization() {
        return this.useSynchronization;
    }

    public Object clone() {
        return this.typeClone();
    }

    public CollectionParameters typeClone() {
        return this.completeClone(new CollectionParameters());
    }

    private CollectionParameters completeClone(CollectionParameters collectionParameters) {
        collectionParameters.capacity = this.capacity;
        collectionParameters.comparatorConfig = this.comparatorConfig;
        collectionParameters.fixedSize = this.fixedSize;
        collectionParameters.restrictions = this.restrictions;
        collectionParameters.constructionFailSilentNullFree = this.constructionFailSilentNullFree;
        collectionParameters.useSynchronization = this.useSynchronization;
        return collectionParameters;
    }

    public static class FixedSize {
        private int minSize = 0;
        private Integer maxSize = null;

        public FixedSize() {
        }

        public FixedSize(int n, Integer n2) {
            Assert.errorParam(n < 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "minSize", n, "0"));
            Assert.errorParam(n2 != null && n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "maxSize", n2, "minSize"));
            Assert.errorParam(n2 != null && n2 < 1, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN, "maxSize", n2, 0));
            this.minSize = n;
            this.maxSize = n2;
        }

        public boolean hasFixedSize() {
            return this.hasMinSize() && this.hasMaxSize();
        }

        public boolean hasMinSize() {
            return this.minSize > 0;
        }

        public boolean hasMaxSize() {
            return this.maxSize != null;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            FixedSize fixedSize = null;
            if (object instanceof FixedSize) {
                fixedSize = (FixedSize)object;
                bl = this.minSize == fixedSize.minSize && Methods.bothEqual(this.maxSize, fixedSize.maxSize);
            }
            return bl;
        }

        public boolean failsFixedSize(int n) {
            return this.failsMinSize(n) && this.failsMaxSize(n);
        }

        public boolean failsMinSize(int n) {
            return n < this.minSize;
        }

        public boolean failsMaxSize(int n) {
            return this.maxSize != null && n > this.maxSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Restrictions {
        private Validator validator;
        private Set<?> restrictedTo;
        private Set<?> restrictedFrom;
        private ValueMethod valueMethod;
        private boolean constructionFailSilent = true;

        public Restrictions() {
        }

        public Restrictions(Validator validator) {
            this(validator, true);
        }

        public Restrictions(ImmutableSet_U immutableSet_U) {
            this(immutableSet_U, new ValueMethod(), true);
        }

        public Restrictions(NullFreeImmutableSet_U nullFreeImmutableSet_U) {
            this(nullFreeImmutableSet_U, new ValueMethod(), true);
        }

        public Restrictions(Validator validator, boolean bl) {
            Assert.errorParam(validator == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "validator"));
            this.validator = validator;
            this.constructionFailSilent = bl;
        }

        public Restrictions(ImmutableSet_U<?> immutableSet_U, ValueMethod valueMethod, boolean bl) {
            Assert.errorParam(immutableSet_U == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "restrictedTo"));
            this.restrictedTo = this.toSimpleSet(immutableSet_U);
            this.valueMethod = valueMethod;
            this.constructionFailSilent = bl;
        }

        public Restrictions(NullFreeImmutableSet_U<?> nullFreeImmutableSet_U, ValueMethod valueMethod, boolean bl) {
            Assert.errorParam(nullFreeImmutableSet_U == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "restrictedFrom"));
            this.restrictedFrom = this.toSimpleSet(nullFreeImmutableSet_U);
            this.valueMethod = valueMethod;
            this.constructionFailSilent = bl;
        }

        private Set toSimpleSet(Collection collection) {
            Set set = null;
            set = SetUtils.orderedSet(new HashSet(collection.size()));
            set.addAll(collection);
            return set;
        }

        public Validator getValidator() {
            return this.validator;
        }

        public ImmutableSet_U<?> getRestrictedTo() {
            return new ImmutableSet_U((java.util.Collection<?>)this.restrictedTo);
        }

        public NullFreeImmutableSet_U<?> getRestrictedFrom() {
            return new NullFreeImmutableSet_U((java.util.Collection<?>)this.restrictedFrom);
        }

        public ValueMethod getValueMethod() {
            return this.valueMethod;
        }

        public boolean getConstructionFailSilent() {
            return this.constructionFailSilent;
        }

        public boolean hasRestrictions() {
            return this.hasRestrictedTo() || this.hasRestrictedFrom();
        }

        public boolean hasValidator() {
            return this.validator != null;
        }

        public boolean hasRestrictedTo() {
            return this.restrictedTo != null;
        }

        public boolean hasRestrictedFrom() {
            return this.restrictedFrom != null;
        }

        public boolean hasValueMethod() {
            return this.valueMethod != null;
        }

        public boolean failsRestrictions(Object object) {
            return this.failsValidator(object) != null || this.failsRestrictedTo(object) || this.failsRestrictedFrom(object);
        }

        public String failsValidator(Object object) {
            return this.validator == null ? null : this.validator.isValid(object);
        }

        public boolean failsRestrictedTo(Object object) {
            return this.restrictedTo != null && !this.restrictedTo.contains(object);
        }

        public boolean failsRestrictedFrom(Object object) {
            return this.restrictedFrom != null && this.restrictedFrom.contains(object);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            Restrictions restrictions = null;
            if (object instanceof Restrictions) {
                restrictions = (Restrictions)object;
                bl = Methods.bothEqual(this.restrictedTo, restrictions.restrictedTo) && Methods.bothEqual(this.restrictedTo, restrictions.restrictedTo) && Methods.bothEqual(this.restrictedFrom, restrictions.restrictedFrom) && Methods.bothEqual(this.valueMethod, restrictions.valueMethod) && this.constructionFailSilent == restrictions.constructionFailSilent;
            }
            return bl;
        }

        public static class ValueMethod {
            private boolean useToString;
            private boolean surroundValueWithQuotes;
            private Method valueMethod;

            public ValueMethod() {
                this.useToString = true;
            }

            public ValueMethod(boolean bl) {
                this.useToString = true;
                this.surroundValueWithQuotes = bl;
            }

            public ValueMethod(Method method) {
                this.valueMethod = method;
            }

            public boolean useToString() {
                return this.useToString;
            }

            public boolean surroundValueWithQuotes() {
                return this.surroundValueWithQuotes;
            }

            public Method getValueMethod() {
                return this.valueMethod;
            }

            public boolean equals(Object object) {
                boolean bl = false;
                ValueMethod valueMethod = null;
                if (object instanceof ValueMethod) {
                    valueMethod = (ValueMethod)object;
                    bl = this.useToString == valueMethod.useToString && Methods.bothEqual(this.valueMethod, valueMethod.valueMethod);
                }
                return bl;
            }
        }

        public static interface Validator {
            public String isValid(Object var1);

            public boolean equals(Object var1);
        }
    }

    public static class ComparatorConfig {
        private Comparator comparator;
        private boolean doConstructionSort;

        public ComparatorConfig() {
        }

        public ComparatorConfig(Comparator comparator, boolean bl) {
            this.comparator = comparator;
            this.doConstructionSort = bl;
        }

        public boolean hasComparator() {
            return this.comparator != null;
        }

        public Comparator getComparator() {
            return this.comparator;
        }

        public boolean getDoConstructionSort() {
            return this.doConstructionSort;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            ComparatorConfig comparatorConfig = null;
            if (object instanceof ComparatorConfig) {
                comparatorConfig = (ComparatorConfig)object;
                bl = Methods.bothEqual(this.comparator, comparatorConfig.comparator) && this.doConstructionSort == comparatorConfig.doConstructionSort;
            }
            return bl;
        }
    }
}

