/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.chores.exec;

import com.jronimo.chores.Constants;
import com.jronimo.chores.objectmodel.Account;
import com.jronimo.chores.objectmodel.Chore;
import com.jronimo.chores.objectmodel.ChoreCompletions;
import com.jronimo.chores.objectmodel.Person;
import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Loader {
    private static final Logger logger = Logger.getLogger(Loader.class);
    private File directory;
    private Long accountId;
    private List<String> fileLines;
    private ChoreCompletions choreCompletions;

    public Loader(File file, Long l) {
        this.directory = file;
        this.accountId = l;
        this.choreCompletions = new ChoreCompletions();
    }

    public Account execute() throws Exception {
        Account account = null;
        account = this.loadAccount();
        this.loadChores(account);
        this.loadChoreCompletions();
        return account;
    }

    private Account loadAccount() throws Exception {
        Account account = null;
        XmlElement xmlElement = null;
        String string = null;
        xmlElement = XmlElementFactory.load(new File(this.directory, "data/Accounts.xml"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("account")) {
            if (!xmlElement2.getElement("id").getLong().equals(this.accountId)) continue;
            string = xmlElement2.getElement("name").getText();
            account = new Account(this.accountId, string);
            this.loadPersons(account, xmlElement2);
            break;
        }
        return account;
    }

    private void loadPersons(Account account, XmlElement xmlElement) throws Exception {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(4));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("persons/person")) {
            set.add(this.loadPerson(xmlElement2));
        }
        account.setPersons(set);
    }

    private Person loadPerson(XmlElement xmlElement) throws Exception {
        Person person = null;
        person = new Person(xmlElement.getLong("id"), xmlElement.getText("name"));
        return person;
    }

    private void loadChores(Account account) throws Exception {
        this.fileLines = FileMethods.readTextFileLines(new File(this.directory, "AccountChores/" + this.accountId + "/Chores.txt"));
        for (Person person : account.getPersons()) {
            this.loadChores(person);
        }
    }

    private void loadChores(Person person) throws Exception {
        Set set = null;
        String string = null;
        set = CollectionUtils.getOrderedSet(new HashSet());
        int n = this.fileLines.size();
        for (int i = 9; i < n; ++i) {
            string = this.fileLines.get(i);
            if (string.indexOf("," + person.getName() + ",") < 0) continue;
            set.add(this.loadChore(string));
        }
        person.setChores(set);
    }

    private Chore loadChore(String string) throws Exception {
        Chore chore = null;
        String[] stringArray = null;
        int n = 0;
        long l = 0L;
        String string2 = null;
        Constants.Frequency frequency = null;
        Comparable<Integer> comparable = null;
        int n2 = 0;
        TimeOfDay timeOfDay = null;
        String string3 = null;
        boolean bl = false;
        Date date = null;
        boolean bl2 = false;
        String string4 = null;
        block16: for (String string5 : stringArray = string.split(",")) {
            switch (++n) {
                case 1: {
                    l = Long.parseLong(string5);
                    continue block16;
                }
                case 2: {
                    string2 = string5;
                    continue block16;
                }
                case 3: {
                    frequency = Constants.Frequency.get(Integer.parseInt(string5));
                    continue block16;
                }
                case 4: {
                    if (frequency == null) continue block16;
                    switch (frequency.getId()) {
                        case 365: 
                        case 730: 
                        case 1095: {
                            comparable = new Date(string5);
                            continue block16;
                        }
                    }
                    comparable = Integer.valueOf(string5);
                    continue block16;
                }
                case 5: {
                    n2 = Integer.parseInt(string5);
                    continue block16;
                }
                case 6: {
                    if (string5.equals("0")) continue block16;
                    timeOfDay = new TimeOfDay(string5);
                    continue block16;
                }
                case 7: {
                    string3 = string5;
                    continue block16;
                }
                case 8: {
                    bl = string5.equalsIgnoreCase("T");
                    continue block16;
                }
                case 9: {
                    date = new Date(string5);
                    continue block16;
                }
                case 10: {
                    bl2 = string5.equalsIgnoreCase("T");
                    continue block16;
                }
                case 11: {
                    string4 = string5;
                }
            }
        }
        chore = new Chore(l, string4, frequency, comparable, n2, timeOfDay, string3, bl, date, bl2);
        return chore;
    }

    private void loadChoreCompletions() throws Exception {
        NullFreeMutableList<String> nullFreeMutableList = null;
        String[] stringArray = null;
        long l = 0L;
        Date date = null;
        nullFreeMutableList = FileMethods.readTextFileLines(new File(this.directory, "AccountChores/" + this.accountId + "/ChoreCompletions.txt"));
        for (String string : nullFreeMutableList) {
            stringArray = string.split("=");
            l = Long.valueOf(stringArray[0]);
            date = new Date(stringArray[1]);
            this.choreCompletions.add(l, date);
        }
    }

    public List<String> getFileLines() {
        return this.fileLines;
    }

    public ChoreCompletions getChoreCompletions() {
        return this.choreCompletions;
    }
}

