/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.chores.exec;

import com.jronimo.chores.exec.Template;
import com.jronimo.chores.objectmodel.Account;
import com.jronimo.chores.objectmodel.Chore;
import com.jronimo.chores.objectmodel.ChoreCompletions;
import com.jronimo.chores.objectmodel.Person;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.StringFormat;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateChoreLists {
    private static final Logger logger = Logger.getLogger(CreateChoreLists.class);
    private Account account;
    private File directory;
    private Date suppliedDate;
    private ChoreCompletions choreCompletions;

    public CreateChoreLists(Account account, File file, Date date, ChoreCompletions choreCompletions) {
        this.account = account;
        this.directory = new File(file, "AccountChores/" + account.getId());
        this.suppliedDate = date;
        this.choreCompletions = choreCompletions;
        this.directory.mkdirs();
    }

    public void execute() throws Exception {
        Date date = null;
        Date date2 = null;
        StringBuilder stringBuilder = null;
        StringFormat.DateFormat dateFormat = null;
        StringFormat stringFormat = null;
        String string = null;
        HashMap<String, String> hashMap = null;
        Template template = null;
        String string2 = null;
        String string3 = null;
        File file = null;
        date = this.getEndDate();
        date2 = Date.addDays(date, -6);
        this.choreCompletions.remove(date2);
        stringBuilder = new StringBuilder();
        for (Person person : this.account.getPersons()) {
            this.processPerson(person, date2, date, stringBuilder);
        }
        string = "Chores - Week starting Monday, " + date2.toString();
        hashMap = new HashMap<String, String>(3);
        hashMap.put("${Page Title}", string);
        hashMap.put("${names}", this.getNames(this.account));
        hashMap.put("${tables}", stringBuilder.toString());
        template = Template.getTemplate("Page");
        string2 = template.replace(hashMap);
        dateFormat = new StringFormat.DateFormat(true);
        dateFormat.setMonthFormatIfNull(Constants.MonthFormat.ABBREVIATION);
        stringFormat = new StringFormat(dateFormat);
        string3 = date2.getString(stringFormat);
        file = new File(this.directory, string3 + ".html");
        FileMethods.writeTextFile(file, string2);
    }

    private void processPerson(Person person, Date date, Date date2, StringBuilder stringBuilder) throws Exception {
        Date date3 = null;
        date3 = date;
        while (date3.lessThanOrEqualTo(date2)) {
            this.processPersonForDay(person, date3, stringBuilder);
            date3 = Date.addDays(date3, 1);
        }
    }

    private void processPersonForDay(Person person, Date date, StringBuilder stringBuilder) throws Exception {
        Set<Chore> set = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        HashMap<String, String> hashMap = null;
        Template template = null;
        set = this.getTodaysChores(date, person);
        string = this.getRows(set);
        string2 = date.getDayOfWeekName() + person.getId();
        string3 = person.getName() + " - " + date.getDayOfWeekName() + " (" + date.toString() + ")";
        hashMap = new HashMap<String, String>(3);
        hashMap.put("${tableId}", string2);
        hashMap.put("${tableHeading}", string3);
        hashMap.put("${rows}", string);
        template = Template.getTemplate("Table");
        stringBuilder.append(template.replace(hashMap));
    }

    private String getNames(Account account) throws Exception {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        for (Person person : account.getPersons()) {
            this.getName(person, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void getName(Person person, StringBuilder stringBuilder) throws Exception {
        stringBuilder.append("<option value=\"");
        stringBuilder.append(person.getId());
        stringBuilder.append("\">");
        stringBuilder.append(person.getName());
        stringBuilder.append("</option>");
    }

    private Date getEndDate() throws Exception {
        Date date = null;
        int n = 0;
        n = 7 - this.suppliedDate.getDayOfWeekNumber();
        date = Date.addDays(this.suppliedDate, n);
        return date;
    }

    private Set<Chore> getTodaysChores(Date date, Person person) throws Exception {
        Set set = null;
        boolean bl = false;
        byte by = 0;
        int n = 0;
        Date date2 = null;
        set = CollectionUtils.getOrderedSet(new HashSet());
        for (Chore chore : person.getChores()) {
            if (chore.hasFrequency()) {
                if (chore.getFrequency().isDaily()) {
                    set.add(chore);
                } else if (chore.getFrequency().isWeekdays() && date.isWeekDay()) {
                    set.add(chore);
                } else if (chore.getFrequency().isWeekend() && !date.isWeekDay()) {
                    set.add(chore);
                } else if (chore.getFrequency().isWeekly() && chore.getDayNumberAsInt() == date.getDayOfWeekNumber()) {
                    set.add(chore);
                } else if (chore.getFrequency().isFortnightly()) {
                    bl = chore.getDayNumberAsInt() <= 7;
                    by = date.getWeekNumber();
                    if (bl) {
                        if (by % 2 == 1 && chore.getDayNumberAsInt() == date.getDayOfWeekNumber()) {
                            set.add(chore);
                        }
                    } else if (by % 2 == 0 && chore.getDayNumberAsInt() % 7 == date.getDayOfWeekNumber()) {
                        set.add(chore);
                    }
                } else if (chore.getFrequency().getId() % 30 == 0) {
                    n = chore.getFrequency().getId() / 30;
                    date2 = Date.addMonths(chore.getLastCompleted(), n);
                    if (date2.equalTo(date)) {
                        set.add(chore);
                    }
                }
            } else {
                date2 = Date.addDays(chore.getLastCompleted(), chore.getDaysBetween());
                if (date2.equalTo(date)) {
                    set.add(chore);
                }
            }
            if (!set.contains(chore)) continue;
            this.choreCompletions.add(chore.getId(), date);
        }
        return set;
    }

    private String getRows(Set<Chore> set) throws Exception {
        StringBuilder stringBuilder = null;
        ArrayList<Chore> arrayList = null;
        arrayList = new ArrayList<Chore>(set.size());
        for (Chore chore : set) {
            arrayList.add(chore);
        }
        Collections.sort(arrayList);
        stringBuilder = new StringBuilder();
        for (Chore chore : arrayList) {
            stringBuilder.append(this.getRow(chore));
        }
        return stringBuilder.toString();
    }

    private String getRow(Chore chore) throws Exception {
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = null;
        Template template = null;
        string2 = chore.hasFrequency() ? String.valueOf(chore.getFrequency().getId()) : "&nbsp;";
        hashMap = new HashMap<String, String>(3);
        hashMap.put("${dayPart}", chore.getDayPart());
        hashMap.put("${frequency}", string2);
        hashMap.put("${choreDescription}", chore.getDescription());
        template = Template.getTemplate("Row");
        string = template.replace(hashMap);
        return string;
    }
}

